% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dethrz_restr.R
\name{check_det_hrz_restr_input}
\alias{check_det_hrz_restr_input}
\title{Checks the arguments of det_hrz_restr}
\usage{
check_det_hrz_restr_input(ppdata, type, criterion, cutoff, hole, integratehole,
  obsprobs, obsprobimage, distancemap, intens, nxprob, covmatrix, returnintens)
}
\arguments{
\item{ppdata}{Observed spatial point process of class ppp.}

\item{type}{Method to use, can be one of \code{"dist"}(method of fixed radius or quantile-based method), or
\code{"intens"}(intensity based method)}

\item{criterion}{criterion to limit the high-risk zone, can be one of
\code{"area"} (giving size of hrz), \code{"indirect"} (giving quantile/alpha depending on type),
or \code{"direct"} (giving radius/threshold c depending on type)}

\item{cutoff}{Value of criterion (area, radius, quantile, alpha or threshold).
Depending on criterion and type.}

\item{hole}{(optional) an object of class \code{owin} representing a region inside the observation window of
the \code{ppdata} where no observations were possible.}

\item{integratehole}{Should the \code{hole} be part of the resulting high-risk zone? Defaults to \code{TRUE}.}

\item{obsprobs}{(optional)  Vector of observation probabilities associated with the observations contained in \code{ppdata}.
Must be given in the same order as the coordinates of the observations. Only meaningful
for the intensity-based method if some observations are located in areas where not all
events can actually be observed. For example, if only one third of the events in a specific region
could be observed, the observation probability of the corresponding observations
is 1/3.}

\item{obsprobimage}{(optional) an object of class \code{im} giving the observation probabilities inside the
observation window. Ranges of the coordinates must equal those of \code{ppdata}.
Only used if \code{obsprobs} is not given.}

\item{distancemap}{(optional) distance map: distance of every pixel to the nearest observation
of the point pattern; only needed for \code{type="dist"}. If not given,
it will be computed by \code{\link[spatstat]{distmap}}.}

\item{intens}{(optional) estimated intensity of the observed process (object of class "im",
see \code{\link[spatstat]{density.ppp}}), only needed for type="intens". If not given,
it will be estimated.}

\item{nxprob}{Probability of having unobserved events.
Default value is 0.1.}

\item{covmatrix}{(optional) Covariance matrix of the kernel of a normal distribution, only needed for
\code{type="intens"} if no intensity is given. If not given, it will be estimated.}

\item{returnintens}{Should the image of the estimated intensity be returned? Defaults to \code{TRUE}.}
}
\description{
For each argument it is checked if it is of a correct value or class.
}
