% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_handling.R
\name{matchTradesQuotes}
\alias{matchTradesQuotes}
\title{Match trade and quote data}
\usage{
matchTradesQuotes(tdata, qdata, adjustment = 2)
}
\arguments{
\item{tdata}{data.table or xts-object containing the trade data (multiple days possible).}

\item{qdata}{data.table or xts-object containing the quote data (multiple days possible).}

\item{adjustment}{numeric, number of seconds the quotes are registered faster than
the trades (should be round and positive). Based on the research of
Vergote (2005), we set 2 seconds as the default.}
}
\value{
data.table or xts-object containing the matched trade and quote data
}
\description{
Function matches the trades and quotes and returns an xts-object containing both.
}
\examples{
# match the trade and quote data
tqdata <- matchTradesQuotes(sample_tdata, sample_qdata)
head(tqdata)
# multi-day input allowed
tqdata <- matchTradesQuotes(sample_tdata_microseconds, sample_qdata_microseconds)
}
\references{
Vergote, O. (2005). How to match trades and quotes for NYSE stocks?
K.U.Leuven working paper.
}
\author{
Jonathan Cornelissen, Kris Boudt and Onno Kleen
}
\keyword{data}
\keyword{manipulation}
