% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lagdata.R
\name{lagdata}
\alias{lagdata}
\title{Create hhsmm data of lagged time series}
\usage{
lagdata(data, lags = 1)
}
\arguments{
\item{data}{a data of class \code{hhsmmdata} containing a multivariate and multi-state time series}

\item{lags}{a positive integer which is the number of lags to be calculated}
}
\value{
a data of class \code{hhsmmdata} containing lagged time series
}
\description{
Creates a data of class \code{hhsmmdata} containing lagged time series
which can be used for fitting auto-regressive hidden hybrid Makrov/semi-Markov
model (AR-HHSMM)
}
\examples{
J <- 3
initial <- c(1, 0, 0)
semi <- rep(FALSE, 3)
P <- matrix(c(0.5, 0.2, 0.3, 0.2, 0.5, 0.3, 0.1, 0.4, 0.5), nrow = J, 
byrow = TRUE)
par <- list(intercept = list(0.1, -0.1, 0.2),
coefficient = list(-0.6, 0.7, -0.5),
csigma = list(5.5, 4, 3.5), mix.p = list(1, 1, 1))
model <- hhsmmspec(init = initial, transition = P, parms.emis = par,
dens.emis = dmixlm, semi = semi)
train <- simulate(model, nsim = c(50, 60, 84, 100), seed = 1234, 
autoregress = TRUE)
laggedtrain = lagdata(train)

}
\author{
Morteza Amini, \email{morteza.amini@ut.ac.ir}
}
