% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hhcartr_export_displayTree.R
\name{displayTree}
\alias{displayTree}
\title{displayTree Display one selected decision tree created from DOT statements.}
\usage{
displayTree(ntree = 1, rpart_ = NA)
}
\arguments{
\item{ntree}{The number of the tree the user wishes to display.}

\item{rpart_}{If specified, it is the rpart() equivalent tree in hhcartr format.}
}
\value{
nothing.
}
\description{
This function displayTree() generates DOT statements for the selected decision tree
in the current model. The DOT statements are written to a temporary file in the tmp
directory. Function grViz() from the DiagrammeR package is then called to visualize
the graph. displayTree() will check to make sure package DiagrammeR is installed and
loaded before attempting generation of DOT statements.
}
\examples{
# source: /man/examples/displayTree.R

# basic usage of displayTree(n)

# Note: need to have something to display first.
X <- iris[,1:4]
y <- iris[,5]
clf = HHDecisionTree(n_folds=1,
                     n_trees=1,
                     pruning=FALSE,
                     min_node_impurity=0.0)
# train our model.
vv <- clf$fit(X, y)
# display the resulting tree.
displayTree(1)

}
