% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unifont.R
\name{unifont}
\alias{unifont}
\title{Load Unifont font}
\usage{
unifont(upper = TRUE, jp = FALSE, csur = TRUE, sample = FALSE, ucp = NULL)
}
\arguments{
\item{upper}{Include glyphs above the Unicode Basic Multilingual plane.}

\item{jp}{Use Japanese version of Chinese characters.}

\item{csur}{Include (Under-)Conscript Unicode Registry glyphs.}

\item{sample}{Add circle to "Combining" characters.}

\item{ucp}{Character vector of Unicode Code Points: glyphs not in this vector won't be read in.
If \code{NULL} (default) read every glyph in the font.}
}
\value{
A \code{\link[bittermelon:bm_font]{bittermelon::bm_font()}} object.
}
\description{
The function \code{unifont()} loads in several GNU Unifont hex files as a
single \code{\link[bittermelon:bm_font]{bittermelon::bm_font()}} object.
}
\examples{
# Much faster to load only the subset of GNU Unifont one needs
# Mandarin Chinese
if (require("bittermelon")) {
  s <- "\uff32\u5f88\u68d2\uff01"
  font <- unifont(ucp = str2ucp(s))
  bm <- as_bm_bitmap(s, font = font)
  print(bm, px = px_ascii)
}

# Emoji
if (require("bittermelon")) {
  s <- "\U0001f42d\U0001f432\U0001f435"
  font <- unifont(ucp = str2ucp(s))
  bm <- as_bm_bitmap(s, font = font)
  print(bm, px = px_ascii)
}
}
