% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VariableSelectionNew.R
\name{RedRate}
\alias{RedRate}
\title{Redundancy Rate}
\usage{
RedRate(
  data_red
)
}
\arguments{
\item{data_red}{A data frame. A subset of data with the selected features.}
}
\value{
   \item{Redundancy Rate}{numeric}
}
\description{
Computes the Redundancy Rate using heterogeneous correlation matrix.
}
\references{
Zhao, Z., L. Wang, and H. Liu (2010). Efficient spectral feature selection with minimum redundancy.
In Proceedings of the AAAI conference on artificial intelligence, Volume 24, pp. 673–678.
}
\examples{

data(ESI)
data=ESI[,-c(1,3,4,6,9)] ##removing categorical features
out=UFS(data,alpha=0.01,method='c',pv_adj='BH')
RR=RedRate(out$selected.features)
RR #visualize the index

}
