% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hermite_estimator_bivar.R
\name{cum_prob.hermite_estimator_bivar}
\alias{cum_prob.hermite_estimator_bivar}
\title{Estimates the cumulative probabilities for a matrix of 2-d x values}
\usage{
\method{cum_prob}{hermite_estimator_bivar}(h_est_obj, x, clipped = FALSE, accelerate_series = FALSE)
}
\arguments{
\item{h_est_obj}{A hermite_estimator_bivar object.}

\item{x}{A numeric matrix. Each row corresponds to a 2-d coordinate.}

\item{clipped}{A boolean value. This value determines whether cumulative
probabilities are clipped to lie within the range [0,1].}

\item{accelerate_series}{A boolean value. Series acceleration has not yet 
been implemented for bivariate estimators.}
}
\value{
A numeric vector of cumulative probability values.
}
\description{
This method calculates the cumulative probability values for a matrix of 
2-d x vector values using the hermite_estimator_bivar object (h_est_obj).
}
\details{
The object must be updated with observations prior to the use of this method.
}
