% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hermite_estimator_bivar.R
\name{dens.hermite_estimator_bivar}
\alias{dens.hermite_estimator_bivar}
\title{Estimates the probability densities for a matrix of 2-d x values}
\usage{
\method{dens}{hermite_estimator_bivar}(this, x, clipped = FALSE, accelerate_series = FALSE)
}
\arguments{
\item{this}{A hermite_estimator_bivar object.}

\item{x}{A numeric matrix. Each row corresponds to a 2-d coordinate.}

\item{clipped}{A boolean value. This value determines whether
probability densities are clipped to be bigger than zero.}

\item{accelerate_series}{A boolean value. Series acceleration has not yet 
been implemented for bivariate estimators.}
}
\value{
A numeric vector of probability density values.
}
\description{
This method calculates the probability density values for a matrix of 
2-d x vector values using the hermite_estimator_bivar object (this).
}
\details{
The object must be updated with observations prior to the use of the method.
}
\examples{
hermite_est <- hermite_estimator_bivar(N = 10, standardize = TRUE)
hermite_est <- update_batch(hermite_est, matrix(rnorm(30*2), nrow=30, 
ncol=2, byrow = TRUE))
cdf_est <- dens(hermite_est, matrix(c(0, 0, 1, 1, 2, 2), nrow=3, ncol=2, 
byrow = TRUE))
}
