% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/states_define.R
\name{define_state_list}
\alias{define_state_list}
\alias{define_state_list_}
\alias{modify.uneval_state_list}
\title{Define Markov Model State List}
\usage{
define_state_list(...)

define_state_list_(.dots)

\method{modify}{uneval_state_list}(.OBJECT, ...)
}
\arguments{
\item{...}{Name-value pairs of expressions defining model
states.}

\item{.dots}{List of states, only used by 
\code{define_state_list_} to avoid using \code{...}.}

\item{.OBJECT}{An \code{uneval_states} object.}
}
\value{
An object of class \code{uneval_state_list} (a
  list of \code{state} objects).
}
\description{
Define the states of a Markov model by combining 
\code{state} objects.
}
\details{
State names have to correspond to those specified through
\code{\link{define_matrix}}.

All states should have the same value names.

The \code{modify} function can modify existing states or 
add new ones.
}
\examples{
\dontrun{
s1 <- define_state(cost = 1, util = 1)
s2 <- define_state(cost = 3, util = .4)

states_mod <- define_state_list(
  healthy = s1,
  sick = s2
)

states_mod

s1_bis <- define_state(cost = 0, util = 1)
s3 <- define_state(cost = 10, util = .1)

modify(
  states_mod,
  healthy = s1_bis,
  sicker = s3
)
}
}

