% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell_defn.R
\name{cell_defn}
\alias{cell_defn}
\title{Allocate Observations to Cells}
\usage{
cell_defn(data, min_size, layers, count = "count")
}
\arguments{
\item{data}{Dataset of discharges.}

\item{min_size}{Minimize cell size.}

\item{layers}{A list of lists. Each layer is a list of the variables
on which observations will be allocated to cells. The layers should
be ordered in decreasing refinement, so that observations not assigned
to a cell meeting the minimum size threshold can be assigned by a
more coarse layer.}

\item{count}{Name of variable which indicates the number of admissions
represented by an observation. Default variable name is \code{count}.}
}
\value{
A list of data frames. The first component in the list, \code{assigned},
is the original data frame, with observations assigned to cells, and
excluding observations that were not assigned. The assigned cells are
designated by the variable \code{cell}, and the layer number in
which the observation is assigned to the cell is given by the variable
\code{cell_type}. The second component of the list, \code{unassigned}, is a
data frame with the unassigned observations.
}
\description{
Take a dataset of hospital discharges, and assigns them to cells that
meet a minimum threshold cell size.
}
\details{
If the variable \code{count} is not available, the function will assume that
each observation represents one admission, and a variable \code{count} will
be created in the output data frame to indicate this.

When assigning observations to cells in a given layer, this function
only assigns observations that have not been previously assigned in a
finer layer. That is, the function assigns observations without
replacement. Assignment with replacement is currently not supported.

For more details see the example vignette by typing:
\code{vignette("semipar_example", package = "healthcare.antitrust")}
}
\examples{
data(discharge_data, package = "healthcare.antitrust")

list1 <- c("drg","age","zip5")
layers <- list(list1)
th <- 15
discharge_data$count <- 1

outList <- cell_defn(discharge_data,th,layers)

}
