#' Color Palette for Journal of Clinical Oncology (JCO)
#'
#' A 10-color discrete color palette based on the colors
#' used in figures in Journal of Clinical Oncology.
#'
#' @keywords internal
palette.jco = function() {
  palette = c('#0073C2', '#EFC000', '#868686', '#CD534C', '#7AA6DC',
              '#003C67', '#8F7700', '#3B3B3B', '#A73030', '#4A6990')
  return(palette)
}

#' Color Palette for Lancet Journals
#'
#' A 10-color discrete color palette based on the colors
#' used in figures in Lancet Oncology.
#'
#' @keywords internal
palette.lancet = function() {
  palette = c('#00468B', '#ED0000', '#42B540', '#0099B4', '#925E9F',
              '#FDAF91', '#AD002A', '#0099B4', '#ADB6B6', '#1B1919')
  return(palette)
}

#' Color Palette for NPG Journals
#'
#' A 10-color discrete color palette based on the colors
#' used in figures in NPG journals such as Nature Reviews Cancer.
#'
#' @keywords internal
palette.npg = function() {
  palette = c('#E64B35', '#4DBBD5', '#00A087', '#3C5488', '#F39B7F',
              '#8491B4', '#91D1C2', '#DC0000', '#7E6148', '#B09C85')
  return(palette)
}

#' Color Palette for AAAS Journals
#'
#' A 10-color discrete color palette based on the colors
#' used in figures in AAAS journals such as Science.
#'
#' @keywords internal
palette.aaas = function() {
  palette = c('#3B4992', '#EE0000', '#008B45', '#631879', '#5F559B',
              '#BB0021', '#008280', '#A20056', '#808180', '#1B1919')
  return(palette)
}
