// Generated by rstantools.  Do not edit by hand.

/*
    hbamr is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    hbamr is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with hbamr.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_BAM_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 67> locations_array__ =
  {" (found before start of program)",
  " (in 'BAM', line 21, column 2 to column 18)",
  " (in 'BAM', line 22, column 2 to column 17)",
  " (in 'BAM', line 23, column 2 to column 69)",
  " (in 'BAM', line 24, column 2 to column 69)",
  " (in 'BAM', line 25, column 2 to column 26)",
  " (in 'BAM', line 26, column 2 to column 33)",
  " (in 'BAM', line 27, column 2 to column 22)",
  " (in 'BAM', line 28, column 2 to column 27)",
  " (in 'BAM', line 29, column 2 to column 17)",
  " (in 'BAM', line 32, column 2 to column 22)",
  " (in 'BAM', line 33, column 2 to column 24)",
  " (in 'BAM', line 34, column 2 to column 38)",
  " (in 'BAM', line 59, column 2 to column 37)",
  " (in 'BAM', line 60, column 2 to column 88)",
  " (in 'BAM', line 61, column 2 to column 21)",
  " (in 'BAM', line 35, column 2 to column 20)",
  " (in 'BAM', line 36, column 2 to column 20)",
  " (in 'BAM', line 37, column 2 to column 20)",
  " (in 'BAM', line 39, column 4 to line 40, column 37)",
  " (in 'BAM', line 38, column 21 to line 41, column 3)",
  " (in 'BAM', line 38, column 2 to line 41, column 3)",
  " (in 'BAM', line 63, column 4 to column 101)",
  " (in 'BAM', line 62, column 2 to line 63, column 101)",
  " (in 'BAM', line 44, column 2 to column 29)",
  " (in 'BAM', line 45, column 2 to column 28)",
  " (in 'BAM', line 46, column 2 to column 33)",
  " (in 'BAM', line 47, column 2 to column 30)",
  " (in 'BAM', line 48, column 2 to column 30)",
  " (in 'BAM', line 49, column 2 to column 45)",
  " (in 'BAM', line 50, column 2 to column 22)",
  " (in 'BAM', line 51, column 2 to column 32)",
  " (in 'BAM', line 52, column 2 to column 37)",
  " (in 'BAM', line 56, column 4 to column 42)",
  " (in 'BAM', line 54, column 4 to column 27)",
  " (in 'BAM', line 53, column 2 to line 56, column 42)",
  " (in 'BAM', line 2, column 2 to column 19)",
  " (in 'BAM', line 3, column 2 to column 19)",
  " (in 'BAM', line 4, column 2 to column 23)",
  " (in 'BAM', line 5, column 8 to column 13)",
  " (in 'BAM', line 5, column 2 to column 33)",
  " (in 'BAM', line 6, column 8 to column 13)",
  " (in 'BAM', line 6, column 2 to column 33)",
  " (in 'BAM', line 7, column 2 to column 19)",
  " (in 'BAM', line 8, column 2 to column 30)",
  " (in 'BAM', line 9, column 2 to column 30)",
  " (in 'BAM', line 10, column 32 to column 37)",
  " (in 'BAM', line 10, column 2 to column 41)",
  " (in 'BAM', line 11, column 32 to column 33)",
  " (in 'BAM', line 11, column 2 to column 37)",
  " (in 'BAM', line 12, column 9 to column 10)",
  " (in 'BAM', line 12, column 2 to column 22)",
  " (in 'BAM', line 13, column 2 to column 31)",
  " (in 'BAM', line 14, column 31 to column 36)",
  " (in 'BAM', line 14, column 2 to column 46)",
  " (in 'BAM', line 17, column 2 to column 55)",
  " (in 'BAM', line 18, column 31 to column 36)",
  " (in 'BAM', line 18, column 2 to column 64)",
  " (in 'BAM', line 21, column 9 to column 10)",
  " (in 'BAM', line 22, column 9 to column 10)",
  " (in 'BAM', line 25, column 8 to column 9)",
  " (in 'BAM', line 28, column 20 to column 21)",
  " (in 'BAM', line 29, column 10 to column 11)",
  " (in 'BAM', line 32, column 8 to column 9)",
  " (in 'BAM', line 33, column 9 to column 14)",
  " (in 'BAM', line 60, column 9 to column 10)",
  " (in 'BAM', line 61, column 14 to column 19)"};
#include <stan_meta_header.hpp>
class model_BAM final : public model_base_crtp<model_BAM> {
private:
  int N;
  int J;
  int N_obs;
  std::vector<int> ii;
  std::vector<int> jj;
  int B;
  int L;
  int R;
  Eigen::Matrix<double,-1,1> Y_data__;
  Eigen::Matrix<double,-1,1> V_data__;
  Eigen::Matrix<double,-1,1> mean_spos_data__;
  int CV;
  Eigen::Matrix<double,-1,1> holdout_data__;
  double tau_prior_rate;
  Eigen::Matrix<double,-1,1> not_holdout_data__;
  Eigen::Map<Eigen::Matrix<double,-1,1>> Y{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> V{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> mean_spos{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> holdout{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> not_holdout{nullptr, 0};
public:
  ~model_BAM() {}
  model_BAM(stan::io::var_context& context__, unsigned int random_seed__ = 0,
            std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_BAM_namespace::model_BAM";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 36;
      context__.validate_dims("data initialization", "N", "int",
        std::vector<size_t>{});
      N = std::numeric_limits<int>::min();
      current_statement__ = 36;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 36;
      stan::math::check_greater_or_equal(function__, "N", N, 1);
      current_statement__ = 37;
      context__.validate_dims("data initialization", "J", "int",
        std::vector<size_t>{});
      J = std::numeric_limits<int>::min();
      current_statement__ = 37;
      J = context__.vals_i("J")[(1 - 1)];
      current_statement__ = 37;
      stan::math::check_greater_or_equal(function__, "J", J, 1);
      current_statement__ = 38;
      context__.validate_dims("data initialization", "N_obs", "int",
        std::vector<size_t>{});
      N_obs = std::numeric_limits<int>::min();
      current_statement__ = 38;
      N_obs = context__.vals_i("N_obs")[(1 - 1)];
      current_statement__ = 38;
      stan::math::check_greater_or_equal(function__, "N_obs", N_obs, 1);
      current_statement__ = 39;
      stan::math::validate_non_negative_index("ii", "N_obs", N_obs);
      current_statement__ = 40;
      context__.validate_dims("data initialization", "ii", "int",
        std::vector<size_t>{static_cast<size_t>(N_obs)});
      ii = std::vector<int>(N_obs, std::numeric_limits<int>::min());
      current_statement__ = 40;
      ii = context__.vals_i("ii");
      current_statement__ = 40;
      stan::math::check_greater_or_equal(function__, "ii", ii, 1);
      current_statement__ = 41;
      stan::math::validate_non_negative_index("jj", "N_obs", N_obs);
      current_statement__ = 42;
      context__.validate_dims("data initialization", "jj", "int",
        std::vector<size_t>{static_cast<size_t>(N_obs)});
      jj = std::vector<int>(N_obs, std::numeric_limits<int>::min());
      current_statement__ = 42;
      jj = context__.vals_i("jj");
      current_statement__ = 42;
      stan::math::check_greater_or_equal(function__, "jj", jj, 1);
      current_statement__ = 43;
      context__.validate_dims("data initialization", "B", "int",
        std::vector<size_t>{});
      B = std::numeric_limits<int>::min();
      current_statement__ = 43;
      B = context__.vals_i("B")[(1 - 1)];
      current_statement__ = 43;
      stan::math::check_greater_or_equal(function__, "B", B, 1);
      current_statement__ = 44;
      context__.validate_dims("data initialization", "L", "int",
        std::vector<size_t>{});
      L = std::numeric_limits<int>::min();
      current_statement__ = 44;
      L = context__.vals_i("L")[(1 - 1)];
      current_statement__ = 44;
      stan::math::check_greater_or_equal(function__, "L", L, 1);
      current_statement__ = 44;
      stan::math::check_less_or_equal(function__, "L", L, J);
      current_statement__ = 45;
      context__.validate_dims("data initialization", "R", "int",
        std::vector<size_t>{});
      R = std::numeric_limits<int>::min();
      current_statement__ = 45;
      R = context__.vals_i("R")[(1 - 1)];
      current_statement__ = 45;
      stan::math::check_greater_or_equal(function__, "R", R, 1);
      current_statement__ = 45;
      stan::math::check_less_or_equal(function__, "R", R, J);
      current_statement__ = 46;
      stan::math::validate_non_negative_index("Y", "N_obs", N_obs);
      current_statement__ = 47;
      context__.validate_dims("data initialization", "Y", "double",
        std::vector<size_t>{static_cast<size_t>(N_obs)});
      Y_data__ = Eigen::Matrix<double,-1,1>::Constant(N_obs,
                   std::numeric_limits<double>::quiet_NaN());
      new (&Y) Eigen::Map<Eigen::Matrix<double,-1,1>>(Y_data__.data(), N_obs);
      {
        std::vector<local_scalar_t__> Y_flat__;
        current_statement__ = 47;
        Y_flat__ = context__.vals_r("Y");
        current_statement__ = 47;
        pos__ = 1;
        current_statement__ = 47;
        for (int sym1__ = 1; sym1__ <= N_obs; ++sym1__) {
          current_statement__ = 47;
          stan::model::assign(Y, Y_flat__[(pos__ - 1)],
            "assigning variable Y", stan::model::index_uni(sym1__));
          current_statement__ = 47;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 47;
      stan::math::check_greater_or_equal(function__, "Y", Y, -B);
      current_statement__ = 47;
      stan::math::check_less_or_equal(function__, "Y", Y, B);
      current_statement__ = 48;
      stan::math::validate_non_negative_index("V", "N", N);
      current_statement__ = 49;
      context__.validate_dims("data initialization", "V", "double",
        std::vector<size_t>{static_cast<size_t>(N)});
      V_data__ = Eigen::Matrix<double,-1,1>::Constant(N,
                   std::numeric_limits<double>::quiet_NaN());
      new (&V) Eigen::Map<Eigen::Matrix<double,-1,1>>(V_data__.data(), N);
      {
        std::vector<local_scalar_t__> V_flat__;
        current_statement__ = 49;
        V_flat__ = context__.vals_r("V");
        current_statement__ = 49;
        pos__ = 1;
        current_statement__ = 49;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 49;
          stan::model::assign(V, V_flat__[(pos__ - 1)],
            "assigning variable V", stan::model::index_uni(sym1__));
          current_statement__ = 49;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 49;
      stan::math::check_greater_or_equal(function__, "V", V, -B);
      current_statement__ = 49;
      stan::math::check_less_or_equal(function__, "V", V, B);
      current_statement__ = 50;
      stan::math::validate_non_negative_index("mean_spos", "J", J);
      current_statement__ = 51;
      context__.validate_dims("data initialization", "mean_spos", "double",
        std::vector<size_t>{static_cast<size_t>(J)});
      mean_spos_data__ = Eigen::Matrix<double,-1,1>::Constant(J,
                           std::numeric_limits<double>::quiet_NaN());
      new (&mean_spos)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(mean_spos_data__.data(), J);
      {
        std::vector<local_scalar_t__> mean_spos_flat__;
        current_statement__ = 51;
        mean_spos_flat__ = context__.vals_r("mean_spos");
        current_statement__ = 51;
        pos__ = 1;
        current_statement__ = 51;
        for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
          current_statement__ = 51;
          stan::model::assign(mean_spos, mean_spos_flat__[(pos__ - 1)],
            "assigning variable mean_spos", stan::model::index_uni(sym1__));
          current_statement__ = 51;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 52;
      context__.validate_dims("data initialization", "CV", "int",
        std::vector<size_t>{});
      CV = std::numeric_limits<int>::min();
      current_statement__ = 52;
      CV = context__.vals_i("CV")[(1 - 1)];
      current_statement__ = 52;
      stan::math::check_greater_or_equal(function__, "CV", CV, 0);
      current_statement__ = 52;
      stan::math::check_less_or_equal(function__, "CV", CV, 1);
      current_statement__ = 53;
      stan::math::validate_non_negative_index("holdout", "N_obs", N_obs);
      current_statement__ = 54;
      context__.validate_dims("data initialization", "holdout", "double",
        std::vector<size_t>{static_cast<size_t>(N_obs)});
      holdout_data__ = Eigen::Matrix<double,-1,1>::Constant(N_obs,
                         std::numeric_limits<double>::quiet_NaN());
      new (&holdout)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(holdout_data__.data(), N_obs);
      {
        std::vector<local_scalar_t__> holdout_flat__;
        current_statement__ = 54;
        holdout_flat__ = context__.vals_r("holdout");
        current_statement__ = 54;
        pos__ = 1;
        current_statement__ = 54;
        for (int sym1__ = 1; sym1__ <= N_obs; ++sym1__) {
          current_statement__ = 54;
          stan::model::assign(holdout, holdout_flat__[(pos__ - 1)],
            "assigning variable holdout", stan::model::index_uni(sym1__));
          current_statement__ = 54;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 54;
      stan::math::check_greater_or_equal(function__, "holdout", holdout, 0);
      current_statement__ = 54;
      stan::math::check_less_or_equal(function__, "holdout", holdout, 1);
      current_statement__ = 55;
      tau_prior_rate = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 55;
      tau_prior_rate = ((2 - 1) / (B / 5.0));
      current_statement__ = 56;
      stan::math::validate_non_negative_index("not_holdout", "N_obs", N_obs);
      current_statement__ = 57;
      not_holdout_data__ = Eigen::Matrix<double,-1,1>::Constant(N_obs,
                             std::numeric_limits<double>::quiet_NaN());
      new (&not_holdout)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(not_holdout_data__.data(),
        N_obs);
      current_statement__ = 57;
      stan::model::assign(not_holdout, stan::math::subtract(1, holdout),
        "assigning variable not_holdout");
      current_statement__ = 55;
      stan::math::check_greater_or_equal(function__, "tau_prior_rate",
        tau_prior_rate, 0);
      current_statement__ = 57;
      stan::math::check_greater_or_equal(function__, "not_holdout",
        not_holdout, 0);
      current_statement__ = 57;
      stan::math::check_less_or_equal(function__, "not_holdout", not_holdout,
        1);
      current_statement__ = 58;
      stan::math::validate_non_negative_index("alpha", "N", N);
      current_statement__ = 59;
      stan::math::validate_non_negative_index("beta", "N", N);
      current_statement__ = 60;
      stan::math::validate_non_negative_index("theta_raw", "J", J);
      current_statement__ = 61;
      stan::math::validate_non_negative_index("eta", "N", N);
      current_statement__ = 62;
      stan::math::validate_positive_index("rho", "J", J);
      current_statement__ = 63;
      stan::math::validate_non_negative_index("theta", "J", J);
      current_statement__ = 64;
      stan::math::validate_non_negative_index("log_lik", "N_obs", N_obs);
      current_statement__ = 65;
      stan::math::validate_non_negative_index("chi", "N", N);
      current_statement__ = 66;
      stan::math::validate_non_negative_index("Y_pred", "N_obs", N_obs);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = N + N + 1 + 1 + J + 1 + 1 + N + (J - 1);
  }
  inline std::string model_name() const final {
    return "model_BAM";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ = "model_BAM_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<local_scalar_t__,-1,1> alpha =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      current_statement__ = 1;
      alpha = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(N);
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      current_statement__ = 2;
      beta = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(N);
      local_scalar_t__ thetal = DUMMY_VAR__;
      current_statement__ = 3;
      thetal = in__.template read_constrain_lub<local_scalar_t__,
                 jacobian__>((stan::model::rvalue(mean_spos, "mean_spos",
                                stan::model::index_uni(L)) - (B / 50.0)),
                 stan::model::rvalue(mean_spos, "mean_spos",
                   stan::model::index_uni(L)), lp__);
      local_scalar_t__ thetar = DUMMY_VAR__;
      current_statement__ = 4;
      thetar = in__.template read_constrain_lub<local_scalar_t__,
                 jacobian__>(stan::model::rvalue(mean_spos, "mean_spos",
                               stan::model::index_uni(R)),
                 (stan::model::rvalue(mean_spos, "mean_spos",
                    stan::model::index_uni(R)) + (B / 50.0)), lp__);
      std::vector<local_scalar_t__> theta_raw =
        std::vector<local_scalar_t__>(J, DUMMY_VAR__);
      current_statement__ = 5;
      theta_raw = in__.template read<std::vector<local_scalar_t__>>(J);
      local_scalar_t__ nu = DUMMY_VAR__;
      current_statement__ = 6;
      nu = in__.template read_constrain_lub<local_scalar_t__, jacobian__>(3,
             30, lp__);
      local_scalar_t__ tau = DUMMY_VAR__;
      current_statement__ = 7;
      tau = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
              lp__);
      Eigen::Matrix<local_scalar_t__,-1,1> eta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      current_statement__ = 8;
      eta = in__.template read_constrain_lb<
              Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0, lp__, N);
      Eigen::Matrix<local_scalar_t__,-1,1> rho =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(J, DUMMY_VAR__);
      current_statement__ = 9;
      rho = in__.template read_constrain_simplex<
              Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(lp__, J);
      std::vector<local_scalar_t__> theta =
        std::vector<local_scalar_t__>(J, DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> log_lik =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N_obs, DUMMY_VAR__);
      local_scalar_t__ eta_scale = DUMMY_VAR__;
      current_statement__ = 12;
      eta_scale = (tau * J);
      current_statement__ = 16;
      stan::model::assign(theta, theta_raw, "assigning variable theta");
      current_statement__ = 17;
      stan::model::assign(theta, thetal, "assigning variable theta",
        stan::model::index_uni(L));
      current_statement__ = 18;
      stan::model::assign(theta, thetar, "assigning variable theta",
        stan::model::index_uni(R));
      current_statement__ = 21;
      for (int n = 1; n <= N_obs; ++n) {
        current_statement__ = 19;
        stan::model::assign(log_lik,
          stan::math::normal_lpdf<false>(
            stan::model::rvalue(Y, "Y", stan::model::index_uni(n)),
            (stan::model::rvalue(alpha, "alpha",
               stan::model::index_uni(
                 stan::model::rvalue(ii, "ii", stan::model::index_uni(n)))) +
            (stan::model::rvalue(beta, "beta",
               stan::model::index_uni(
                 stan::model::rvalue(ii, "ii", stan::model::index_uni(n)))) *
            stan::model::rvalue(theta, "theta",
              stan::model::index_uni(
                stan::model::rvalue(jj, "jj", stan::model::index_uni(n)))))),
            (stan::math::sqrt(
               stan::model::rvalue(eta, "eta",
                 stan::model::index_uni(
                   stan::model::rvalue(ii, "ii", stan::model::index_uni(n)))))
            *
            stan::model::rvalue(rho, "rho",
              stan::model::index_uni(
                stan::model::rvalue(jj, "jj", stan::model::index_uni(n)))))),
          "assigning variable log_lik", stan::model::index_uni(n));
      }
      current_statement__ = 12;
      stan::math::check_greater_or_equal(function__, "eta_scale", eta_scale,
        0);
      {
        current_statement__ = 24;
        lp_accum__.add(stan::math::uniform_lpdf<propto__>(alpha, -100, 100));
        current_statement__ = 25;
        lp_accum__.add(stan::math::uniform_lpdf<propto__>(beta, -100, 100));
        current_statement__ = 26;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(theta_raw, 0, (B /
                         2.0)));
        current_statement__ = 27;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(thetal, 0, (B / 2.0)));
        current_statement__ = 28;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(thetar, 0, (B / 2.0)));
        current_statement__ = 29;
        lp_accum__.add(stan::math::scaled_inv_chi_square_lpdf<propto__>(eta,
                         nu, eta_scale));
        current_statement__ = 30;
        lp_accum__.add(stan::math::gamma_lpdf<propto__>(nu, 25, 2.5));
        current_statement__ = 31;
        lp_accum__.add(stan::math::gamma_lpdf<propto__>(tau, 2, (5 / (B *
                         1.0))));
        current_statement__ = 32;
        lp_accum__.add(stan::math::dirichlet_lpdf<propto__>(rho,
                         stan::math::rep_vector(50, J)));
        current_statement__ = 35;
        if (stan::math::logical_eq(CV, 0)) {
          current_statement__ = 34;
          lp_accum__.add(stan::math::sum(log_lik));
        } else {
          current_statement__ = 33;
          lp_accum__.add(stan::math::sum(
                           stan::math::elt_multiply(log_lik, not_holdout)));
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_BAM_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<double,-1,1> alpha =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      alpha = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(N);
      Eigen::Matrix<double,-1,1> beta =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 2;
      beta = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(N);
      double thetal = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 3;
      thetal = in__.template read_constrain_lub<local_scalar_t__,
                 jacobian__>((stan::model::rvalue(mean_spos, "mean_spos",
                                stan::model::index_uni(L)) - (B / 50.0)),
                 stan::model::rvalue(mean_spos, "mean_spos",
                   stan::model::index_uni(L)), lp__);
      double thetar = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 4;
      thetar = in__.template read_constrain_lub<local_scalar_t__,
                 jacobian__>(stan::model::rvalue(mean_spos, "mean_spos",
                               stan::model::index_uni(R)),
                 (stan::model::rvalue(mean_spos, "mean_spos",
                    stan::model::index_uni(R)) + (B / 50.0)), lp__);
      std::vector<double> theta_raw =
        std::vector<double>(J, std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 5;
      theta_raw = in__.template read<std::vector<local_scalar_t__>>(J);
      double nu = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 6;
      nu = in__.template read_constrain_lub<local_scalar_t__, jacobian__>(3,
             30, lp__);
      double tau = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 7;
      tau = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
              lp__);
      Eigen::Matrix<double,-1,1> eta =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 8;
      eta = in__.template read_constrain_lb<
              Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0, lp__, N);
      Eigen::Matrix<double,-1,1> rho =
        Eigen::Matrix<double,-1,1>::Constant(J,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 9;
      rho = in__.template read_constrain_simplex<
              Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(lp__, J);
      std::vector<double> theta =
        std::vector<double>(J, std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> log_lik =
        Eigen::Matrix<double,-1,1>::Constant(N_obs,
          std::numeric_limits<double>::quiet_NaN());
      double eta_scale = std::numeric_limits<double>::quiet_NaN();
      out__.write(alpha);
      out__.write(beta);
      out__.write(thetal);
      out__.write(thetar);
      out__.write(theta_raw);
      out__.write(nu);
      out__.write(tau);
      out__.write(eta);
      out__.write(rho);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 12;
      eta_scale = (tau * J);
      current_statement__ = 16;
      stan::model::assign(theta, theta_raw, "assigning variable theta");
      current_statement__ = 17;
      stan::model::assign(theta, thetal, "assigning variable theta",
        stan::model::index_uni(L));
      current_statement__ = 18;
      stan::model::assign(theta, thetar, "assigning variable theta",
        stan::model::index_uni(R));
      current_statement__ = 21;
      for (int n = 1; n <= N_obs; ++n) {
        current_statement__ = 19;
        stan::model::assign(log_lik,
          stan::math::normal_lpdf<false>(
            stan::model::rvalue(Y, "Y", stan::model::index_uni(n)),
            (stan::model::rvalue(alpha, "alpha",
               stan::model::index_uni(
                 stan::model::rvalue(ii, "ii", stan::model::index_uni(n)))) +
            (stan::model::rvalue(beta, "beta",
               stan::model::index_uni(
                 stan::model::rvalue(ii, "ii", stan::model::index_uni(n)))) *
            stan::model::rvalue(theta, "theta",
              stan::model::index_uni(
                stan::model::rvalue(jj, "jj", stan::model::index_uni(n)))))),
            (stan::math::sqrt(
               stan::model::rvalue(eta, "eta",
                 stan::model::index_uni(
                   stan::model::rvalue(ii, "ii", stan::model::index_uni(n)))))
            *
            stan::model::rvalue(rho, "rho",
              stan::model::index_uni(
                stan::model::rvalue(jj, "jj", stan::model::index_uni(n)))))),
          "assigning variable log_lik", stan::model::index_uni(n));
      }
      current_statement__ = 12;
      stan::math::check_greater_or_equal(function__, "eta_scale", eta_scale,
        0);
      if (emit_transformed_parameters__) {
        out__.write(theta);
        out__.write(log_lik);
        out__.write(eta_scale);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      double min_rho = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 13;
      min_rho = stan::math::min(rho);
      Eigen::Matrix<double,-1,1> chi =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 14;
      stan::model::assign(chi,
        stan::math::elt_divide(
          stan::math::subtract(
            stan::math::subtract(V,
              stan::math::to_vector(
                stan::math::normal_rng(0,
                  stan::math::multiply(stan::math::sqrt(eta), min_rho),
                  base_rng__))), alpha), beta), "assigning variable chi");
      std::vector<double> Y_pred =
        std::vector<double>(N_obs, std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 23;
      for (int n = 1; n <= N_obs; ++n) {
        current_statement__ = 22;
        stan::model::assign(Y_pred,
          stan::math::normal_rng(
            (stan::model::rvalue(alpha, "alpha",
               stan::model::index_uni(
                 stan::model::rvalue(ii, "ii", stan::model::index_uni(n)))) +
            (stan::model::rvalue(beta, "beta",
               stan::model::index_uni(
                 stan::model::rvalue(ii, "ii", stan::model::index_uni(n)))) *
            stan::model::rvalue(theta, "theta",
              stan::model::index_uni(
                stan::model::rvalue(jj, "jj", stan::model::index_uni(n)))))),
            (stan::math::sqrt(
               stan::model::rvalue(eta, "eta",
                 stan::model::index_uni(
                   stan::model::rvalue(ii, "ii", stan::model::index_uni(n)))))
            *
            stan::model::rvalue(rho, "rho",
              stan::model::index_uni(
                stan::model::rvalue(jj, "jj", stan::model::index_uni(n))))),
            base_rng__), "assigning variable Y_pred",
          stan::model::index_uni(n));
      }
      current_statement__ = 13;
      stan::math::check_greater_or_equal(function__, "min_rho", min_rho, 0);
      out__.write(min_rho);
      out__.write(chi);
      out__.write(Y_pred);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> alpha =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(alpha,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(N),
        "assigning variable alpha");
      out__.write(alpha);
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      current_statement__ = 2;
      stan::model::assign(beta,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(N),
        "assigning variable beta");
      out__.write(beta);
      local_scalar_t__ thetal = DUMMY_VAR__;
      current_statement__ = 3;
      thetal = in__.read<local_scalar_t__>();
      out__.write_free_lub((stan::model::rvalue(mean_spos, "mean_spos",
                              stan::model::index_uni(L)) - (B / 50.0)),
        stan::model::rvalue(mean_spos, "mean_spos", stan::model::index_uni(L)),
        thetal);
      local_scalar_t__ thetar = DUMMY_VAR__;
      current_statement__ = 4;
      thetar = in__.read<local_scalar_t__>();
      out__.write_free_lub(stan::model::rvalue(mean_spos, "mean_spos",
                             stan::model::index_uni(R)),
        (stan::model::rvalue(mean_spos, "mean_spos",
           stan::model::index_uni(R)) + (B / 50.0)), thetar);
      std::vector<local_scalar_t__> theta_raw =
        std::vector<local_scalar_t__>(J, DUMMY_VAR__);
      current_statement__ = 5;
      stan::model::assign(theta_raw,
        in__.read<std::vector<local_scalar_t__>>(J),
        "assigning variable theta_raw");
      out__.write(theta_raw);
      local_scalar_t__ nu = DUMMY_VAR__;
      current_statement__ = 6;
      nu = in__.read<local_scalar_t__>();
      out__.write_free_lub(3, 30, nu);
      local_scalar_t__ tau = DUMMY_VAR__;
      current_statement__ = 7;
      tau = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, tau);
      Eigen::Matrix<local_scalar_t__,-1,1> eta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      current_statement__ = 8;
      stan::model::assign(eta,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(N),
        "assigning variable eta");
      out__.write_free_lb(0, eta);
      Eigen::Matrix<local_scalar_t__,-1,1> rho =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(J, DUMMY_VAR__);
      current_statement__ = 9;
      stan::model::assign(rho,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(J),
        "assigning variable rho");
      out__.write_free_simplex(rho);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "alpha", "double",
        std::vector<size_t>{static_cast<size_t>(N)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "beta", "double",
        std::vector<size_t>{static_cast<size_t>(N)});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "thetal", "double",
        std::vector<size_t>{});
      current_statement__ = 4;
      context__.validate_dims("parameter initialization", "thetar", "double",
        std::vector<size_t>{});
      current_statement__ = 5;
      context__.validate_dims("parameter initialization", "theta_raw",
        "double", std::vector<size_t>{static_cast<size_t>(J)});
      current_statement__ = 6;
      context__.validate_dims("parameter initialization", "nu", "double",
        std::vector<size_t>{});
      current_statement__ = 7;
      context__.validate_dims("parameter initialization", "tau", "double",
        std::vector<size_t>{});
      current_statement__ = 8;
      context__.validate_dims("parameter initialization", "eta", "double",
        std::vector<size_t>{static_cast<size_t>(N)});
      current_statement__ = 9;
      context__.validate_dims("parameter initialization", "rho", "double",
        std::vector<size_t>{static_cast<size_t>(J)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> alpha =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> alpha_flat__;
        current_statement__ = 1;
        alpha_flat__ = context__.vals_r("alpha");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 1;
          stan::model::assign(alpha, alpha_flat__[(pos__ - 1)],
            "assigning variable alpha", stan::model::index_uni(sym1__));
          current_statement__ = 1;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(alpha);
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 2;
        beta_flat__ = context__.vals_r("beta");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 2;
          stan::model::assign(beta, beta_flat__[(pos__ - 1)],
            "assigning variable beta", stan::model::index_uni(sym1__));
          current_statement__ = 2;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(beta);
      local_scalar_t__ thetal = DUMMY_VAR__;
      current_statement__ = 3;
      thetal = context__.vals_r("thetal")[(1 - 1)];
      out__.write_free_lub((stan::model::rvalue(mean_spos, "mean_spos",
                              stan::model::index_uni(L)) - (B / 50.0)),
        stan::model::rvalue(mean_spos, "mean_spos", stan::model::index_uni(L)),
        thetal);
      local_scalar_t__ thetar = DUMMY_VAR__;
      current_statement__ = 4;
      thetar = context__.vals_r("thetar")[(1 - 1)];
      out__.write_free_lub(stan::model::rvalue(mean_spos, "mean_spos",
                             stan::model::index_uni(R)),
        (stan::model::rvalue(mean_spos, "mean_spos",
           stan::model::index_uni(R)) + (B / 50.0)), thetar);
      std::vector<local_scalar_t__> theta_raw =
        std::vector<local_scalar_t__>(J, DUMMY_VAR__);
      current_statement__ = 5;
      theta_raw = context__.vals_r("theta_raw");
      out__.write(theta_raw);
      local_scalar_t__ nu = DUMMY_VAR__;
      current_statement__ = 6;
      nu = context__.vals_r("nu")[(1 - 1)];
      out__.write_free_lub(3, 30, nu);
      local_scalar_t__ tau = DUMMY_VAR__;
      current_statement__ = 7;
      tau = context__.vals_r("tau")[(1 - 1)];
      out__.write_free_lb(0, tau);
      Eigen::Matrix<local_scalar_t__,-1,1> eta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> eta_flat__;
        current_statement__ = 8;
        eta_flat__ = context__.vals_r("eta");
        current_statement__ = 8;
        pos__ = 1;
        current_statement__ = 8;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 8;
          stan::model::assign(eta, eta_flat__[(pos__ - 1)],
            "assigning variable eta", stan::model::index_uni(sym1__));
          current_statement__ = 8;
          pos__ = (pos__ + 1);
        }
      }
      out__.write_free_lb(0, eta);
      Eigen::Matrix<local_scalar_t__,-1,1> rho =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(J, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> rho_flat__;
        current_statement__ = 9;
        rho_flat__ = context__.vals_r("rho");
        current_statement__ = 9;
        pos__ = 1;
        current_statement__ = 9;
        for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
          current_statement__ = 9;
          stan::model::assign(rho, rho_flat__[(pos__ - 1)],
            "assigning variable rho", stan::model::index_uni(sym1__));
          current_statement__ = 9;
          pos__ = (pos__ + 1);
        }
      }
      out__.write_free_simplex(rho);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"alpha", "beta", "thetal", "thetar",
                "theta_raw", "nu", "tau", "eta", "rho"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"theta", "log_lik", "eta_scale"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::string> temp{"min_rho", "chi", "Y_pred"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(N)},
                std::vector<size_t>{static_cast<size_t>(N)},
                std::vector<size_t>{}, std::vector<size_t>{},
                std::vector<size_t>{static_cast<size_t>(J)},
                std::vector<size_t>{}, std::vector<size_t>{},
                std::vector<size_t>{static_cast<size_t>(N)},
                std::vector<size_t>{static_cast<size_t>(J)}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(J)},
             std::vector<size_t>{static_cast<size_t>(N_obs)},
             std::vector<size_t>{}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{},
             std::vector<size_t>{static_cast<size_t>(N)},
             std::vector<size_t>{static_cast<size_t>(N_obs)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
      param_names__.emplace_back(std::string() + "alpha" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "thetal");
    param_names__.emplace_back(std::string() + "thetar");
    for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
      param_names__.emplace_back(std::string() + "theta_raw" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "nu");
    param_names__.emplace_back(std::string() + "tau");
    for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
      param_names__.emplace_back(std::string() + "eta" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
      param_names__.emplace_back(std::string() + "rho" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        param_names__.emplace_back(std::string() + "theta" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N_obs; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_lik" + '.' +
          std::to_string(sym1__));
      }
      param_names__.emplace_back(std::string() + "eta_scale");
    }
    if (emit_generated_quantities__) {
      param_names__.emplace_back(std::string() + "min_rho");
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "chi" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N_obs; ++sym1__) {
        param_names__.emplace_back(std::string() + "Y_pred" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
      param_names__.emplace_back(std::string() + "alpha" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "thetal");
    param_names__.emplace_back(std::string() + "thetar");
    for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
      param_names__.emplace_back(std::string() + "theta_raw" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "nu");
    param_names__.emplace_back(std::string() + "tau");
    for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
      param_names__.emplace_back(std::string() + "eta" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= (J - 1); ++sym1__) {
      param_names__.emplace_back(std::string() + "rho" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        param_names__.emplace_back(std::string() + "theta" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N_obs; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_lik" + '.' +
          std::to_string(sym1__));
      }
      param_names__.emplace_back(std::string() + "eta_scale");
    }
    if (emit_generated_quantities__) {
      param_names__.emplace_back(std::string() + "min_rho");
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "chi" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N_obs; ++sym1__) {
        param_names__.emplace_back(std::string() + "Y_pred" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"alpha\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"parameters\"},{\"name\":\"thetal\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"thetar\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"theta_raw\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(J) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"nu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"parameters\"},{\"name\":\"rho\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(J) + "},\"block\":\"parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(J) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N_obs) + "},\"block\":\"transformed_parameters\"},{\"name\":\"eta_scale\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"min_rho\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"chi\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"},{\"name\":\"Y_pred\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N_obs) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"alpha\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"parameters\"},{\"name\":\"thetal\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"thetar\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"theta_raw\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(J) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"nu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"parameters\"},{\"name\":\"rho\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string((J -1)) + "},\"block\":\"parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(J) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N_obs) + "},\"block\":\"transformed_parameters\"},{\"name\":\"eta_scale\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"min_rho\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"chi\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"},{\"name\":\"Y_pred\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N_obs) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((((((N + N) + 1) + 1) + J) + 1) + 1) + N)
      + J);
    const size_t num_transformed = emit_transformed_parameters * (((J +
      N_obs) + 1));
    const size_t num_gen_quantities = emit_generated_quantities * (((1 + N) +
      N_obs));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((((((N + N) + 1) + 1) + J) + 1) + 1) + N)
      + J);
    const size_t num_transformed = emit_transformed_parameters * (((J +
      N_obs) + 1));
    const size_t num_gen_quantities = emit_generated_quantities * (((1 + N) +
      N_obs));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_BAM_namespace::model_BAM;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_BAM_namespace::profiles__;
}
#endif
#endif
