% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haven.R
\name{read_spss}
\alias{read_por}
\alias{read_sav}
\alias{read_spss}
\alias{write_sav}
\title{Read SPSS (POR and SAV) files. Write SAV files.}
\usage{
read_por(path)

read_sav(path)

write_sav(data, path)

read_spss(path)
}
\arguments{
\item{path}{Path to data. When reading data, if the path is a URL, the file
will be first downloaded to a temporary location before reading.}

\item{data}{Data frame to write.}
}
\value{
A data frame with additional "tbl_df" and "tbl" classes, which
  improve printing if dplyr is loaded.

  Variable labels are stored in the "label" attribute of each variable.
  It is not printed on the console, but the RStudio viewer will show it.
}
\description{
Currently haven can read and write logical, integer, numeric, character
and factors. See \code{\link{labelled}} for how labelled variables in
Stata are handled in R. \code{read_spss} is an alias for \code{read_sav}.
}
\examples{
tmp <- tempfile(fileext = ".sav")
write_sav(mtcars, tmp)
read_sav(tmp)
}

