% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize.R
\name{standardize}
\alias{standardize}
\title{Standardize the outcome}
\usage{
standardize(y)
}
\arguments{
\item{y}{The outcome. This can be:
\itemize{
\item A factor vector
\item A numeric vector
\item A 1D numeric array
\item A numeric matrix with column names
\item A 2D numeric array with column names
\item A data frame with numeric or factor columns
}}
}
\value{
All possible values of \code{y} are transformed into a \code{tibble} for
standardization. Vectors are transformed into a \code{tibble} with
a single column named \code{".outcome"}.
}
\description{
Most of the time, the input to a model should be flexible enough to capture
a number of different input types from the user. \code{standardize()} focuses
on capturing the flexibility in the \emph{outcome}.
}
\details{
\code{standardize()} is called from \code{\link[=mold]{mold()}} when using an XY interface (i.e.
a \code{y} argument was supplied).
}
\examples{
standardize(1:5)

standardize(factor(letters[1:5]))

mat <- matrix(1:10, ncol = 2)
colnames(mat) <- c("a", "b")
standardize(mat)

df <- data.frame(x = 1:5, y = 6:10)
standardize(df)

}
