% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hanr_wavelet.R
\name{hanr_wavelet}
\alias{hanr_wavelet}
\title{Anomaly detector using Wavelet}
\usage{
hanr_wavelet(filter = "haar")
}
\arguments{
\item{filter}{Availables wavelet filters: haar, d4, la8, bl14, c6}
}
\value{
\code{hanr_wavelet} object
}
\description{
Anomaly detection using Wavelet
The Wavelet model adjusts to the time series. Observations distant from the model are labeled as anomalies.
It wraps the Wavelet model presented in the stats library.
}
\examples{
library(daltoolbox)

#loading the example database
data(examples_anomalies)

#Using simple example
dataset <- examples_anomalies$simple
head(dataset)

# setting up time series fft detector
model <- hanr_wavelet()

# fitting the model
model <- fit(model, dataset$serie)

detection <- detect(model, dataset$serie)

# filtering detected events
print(detection[(detection$event),])

}
