% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commons_written_questions.R
\name{commons_written_questions}
\alias{commons_written_questions}
\alias{hansard_commons_written_questions}
\title{Imports data in a tibble on House of Commons written questions.}
\usage{
commons_written_questions(mp_id = NULL, answering_department = NULL,
  start_date = "1900-01-01", end_date = Sys.Date(), extra_args = NULL,
  tidy = TRUE, tidy_style = "snake_case")

hansard_commons_written_questions(mp_id = NULL, answering_department = NULL,
  start_date = "1900-01-01", end_date = Sys.Date(), extra_args = NULL,
  tidy = TRUE, tidy_style = "snake_case")
}
\arguments{
\item{mp_id}{Requests a member ID and returns a tibble with all written questions asked by that member. If NULL, mp_id is not included as a query parameter. Defaults to NULL.}

\item{answering_department}{Accepts a string with a department name or partial name, and returns all written questions by that department. The query acts as a search, so entering <health> will return all questions answered by the Department of Health. If NULL, answering_department is not included as a query parameter. Defaults to NULL.}

\item{start_date}{The earliest date to include in the tibble. Defaults to '1900-01-01'. Accepts character values in 'YYYY-MM-DD' format, and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}.}

\item{end_date}{The latest date to include in the tibble. Defaults to current system date. Defaults to '1900-01-01'. Accepts character values in 'YYYY-MM-DD' format, and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}.}

\item{extra_args}{Additional parameters to pass to API. Defaults to NULL.}

\item{tidy}{Fix the variable names in the tibble to remove special characters and superfluous text, and converts the variable names to a consistent style. Defaults to TRUE.}

\item{tidy_style}{The style to convert variable names to, if tidy = TRUE. Accepts one of 'snake_case', 'camelCase' and 'period.case'. Defaults to 'snake_case'.}
}
\value{
A tibble with details on written questions in the House of Commons.
}
\description{
Imports data in a tibble on House of Commons written questions.
}
\examples{
\dontrun{

x <- commons_written_questions(mp_id=410, 'cabinet office')
#Returns a tibble with written questions from Jon Trickett, answered by the Cabinet Office.

}
}
\keyword{Commons}
\keyword{House}
\keyword{Questions}
\keyword{Written}
\keyword{of}
