% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publication_logs.R
\name{publication_logs}
\alias{publication_logs}
\alias{hansard_publication_logs}
\title{Imports data on House of Commons and House of Lords publications.}
\usage{
publication_logs(ID = NULL, house = NULL, start_date = "1900-01-01",
  end_date = Sys.Date(), extra_args = NULL, tidy = TRUE,
  tidy_style = "snake_case")

hansard_publication_logs(ID = NULL, house = NULL,
  start_date = "1900-01-01", end_date = Sys.Date(), extra_args = NULL,
  tidy = TRUE, tidy_style = "snake_case")
}
\arguments{
\item{ID}{Publication ID. Defaults to NULL. If not NULL, requests a tibble with information on the given publication.}

\item{house}{The house that produced the particular publication. Accepts 'commons' and 'lords'. If NULL or not 'commons' or 'lords', returns publications from both House of Commons and House of Lords. This parameter is case-insensitive. Defaults to NULL.}

\item{start_date}{The earliest date to include in the tibble. Defaults to '1900-01-01'. Accepts character values in 'YYYY-MM-DD' format, and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}.}

\item{end_date}{The latest date to include in the tibble. Defaults to current system date. Defaults to '1900-01-01'. Accepts character values in 'YYYY-MM-DD' format, and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}.}

\item{extra_args}{Additional parameters to pass to API. Defaults to NULL.}

\item{tidy}{Fix the variable names in the tibble to remove special characters and superfluous text, and converts the variable names to a consistent style. Defaults to TRUE.}

\item{tidy_style}{The style to convert variable names to, if tidy = TRUE. Accepts one of 'snake_case', 'camelCase' and 'period.case'. Defaults to 'snake_case'.}
}
\description{
Imports data on House of Commons and House of Lords publications.
}
\examples{
\dontrun{

x <- publication_logs(house='commons')

x <- publication_logs(683267)
}
}
\keyword{Logs}
\keyword{Publication}
