% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tex-utils.R
\name{tex.catwitherror}
\alias{tex.catwitherror}
\title{paste a number with error in tex-ready format}
\usage{
tex.catwitherror(x, dx, digits = 1, with.dollar = TRUE, with.cdot = TRUE,
  ...)
}
\arguments{
\item{x}{either a single numeric value, or a numeric vector, where the first
element is the value and the second is its error}

\item{dx}{the error. If supplied, it will be printed as the error and the
value is the first element of \code{x}. If \code{dx} is missing, the second
element of \code{x}, if available, is used as the error. If \code{dx} is
missing and the length of \code{x} is one, only the value is converted to a
string without error.}

\item{digits}{number of error digits}

\item{with.dollar}{include the tex dollar in the return string or not}

\item{with.cdot}{replace the "e" in scientific notation by tex-style "cdot" or not}

\item{...}{arguments to be passed to \code{formatC} in case of no error, or
to \code{format.errors} otherwise}
}
\value{
writes a string to standard output
}
\description{
A number with error is converted to a string in tex-ready format like xx(yy)
thereby automatically determining the digit at which the error applies.
}
\details{
It is strongly recommended to install the \code{errors}-package. Otherwise
the formatting options are significantly reduced.

The value of the first element of \code{x} is properly rounded to its
significant digits determined by the values of \code{dx} or the second
element of \code{x} (see above) and \code{digits}. Then a tex-ready string
is returned.
}
\examples{

tex.catwitherror(x=0.375567, dx=0.001)
tex.catwitherror(x=c(0.375567, 0.001))
## it can be used with apply
x = array(c(0.1187, 0.291, 0.388, 0.011, 0.037, 0.021), dim=c(3,2))
apply(x, 1, tex.catwitherror, digits=2)

}
\author{
Carsten Urbach, \email{curbach@gmx.de} and Johann Ostmeyer
}
