% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/looptools.R
\name{disc_3pt}
\alias{disc_3pt}
\title{disconnected contribution to current insertion three-point function}
\usage{
disc_3pt(cf_2pt, loop, src_ts, dt, reim_loop = "both", reim_2pt = "both",
  vev_subtract = FALSE)
}
\arguments{
\item{cf_2pt}{'raw_cf' container holding two-point part of three-point function
in lattice-absolute coordinates (not relative to source!)}

\item{loop}{'raw_cf' container holding loop contribution, suitably spin-projected
and averaged over stochastic samples.}

\item{src_ts}{Integer vector, the source time slices that were used for the computation
of the two-point function in lattice-absolute coordinates.
Must be of the same length as the number of measurements in \code{cf_2pt}.}

\item{dt}{Integer, the source-sink separation that should be computed.}

\item{reim_loop}{String, one of 'real', 'imag' or 'both'. Specifies whether
just the real or imaginary part should be considered when
constructing the correlation with the two-point function.}

\item{reim_2pt}{String, same as \code{reim_loop} but for the two-point
contribution to the three-point function.}

\item{vev_subtract}{Boolean, whether the loop contains a vev which should
be subtracted.}
}
\value{
\code{raw_cf} container with the product of loop and 2pt function, shifted
in time to be relative to source using the info from \code{src_ts}
}
\description{
Computes the quark-line disconnected contribution to a three-point function
of the form
\deqn{ C_3(t, \Delta t = t_{snk} - t_{src}) = C_2(t_{snk}, t_{src}) * L(t) }
\eqn{\forall t} considering only the case t_{snk} > t_{src}.
}
