% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hablar.R
\name{as_reliable}
\alias{as_reliable}
\alias{as_reliable_num}
\alias{as_reliable_int}
\alias{as_reliable_lgl}
\alias{as_reliable_dte}
\alias{as_reliable_dtm}
\title{Reliable conversion to another data type}
\usage{
as_reliable_num(.x, ...)

as_reliable_int(.x, ...)

as_reliable_lgl(.x, ...)

as_reliable_dte(.x, origin = "1970-01-01", ...)

as_reliable_dtm(.x, origin = "1970-01-01", tz = "Europe/London", ...)

as_reliable_int(.x, ...)

as_reliable_lgl(.x, ...)

as_reliable_dte(.x, origin = "1970-01-01", ...)

as_reliable_dtm(.x, origin = "1970-01-01", tz = "Europe/London", ...)
}
\arguments{
\item{.x}{vector}

\item{...}{additional arguments}

\item{origin}{argument to set origin for date/date time.}

\item{tz}{argument to set time zone for date/date time. Default is Europe/London.}
}
\value{
vector
}
\description{
Support functions for the \code{convert} function. These functions coerces vectors to a new data type, e.g. \code{as.numeric}
except that it converts factors to character first.
See \code{\link{convert}} for more information.
}
\examples{
x <- as.factor(c("1", "3.5"))
as_reliable_num(x)

x <- as.factor(c("9", "7"))
as_reliable_int(x)

x <- as.factor(c("1", "0"))
as_reliable_lgl(x)

}
\seealso{
\code{vignette("convert")}, \code{vignette("hablar")}
}
