% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vertexes.R
\name{get_cell_vertex}
\alias{get_cell_vertex}
\title{Get a vertex index}
\usage{
get_cell_vertex(h3_address = NULL, v_num = 0, simple = TRUE)
}
\arguments{
\item{h3_address}{Character; 15-character cell index generated by H3. A
vector of indexes can also be supplied.}

\item{v_num}{Numeric; the vertex number required. Options are 0-5 inclusive.}

\item{simple}{Logical; whether to return a vector of outputs or a data frame
containing both inputs and outputs.}
}
\value{
By default, a list of \code{length(h3_address)}.
}
\description{
This function returns the vertex index for a supplied H3 cell and vertex
number.
}
\examples{
# Get vertex 3 for this cell
get_cell_vertex(h3_address = '86be8d12fffffff', 3)

}
