% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h3_algorithms.R
\name{get_ring}
\alias{get_ring}
\title{Get a donut of H3 cell indexes}
\usage{
get_ring(h3_address = NULL, ring_size = 1, simple = TRUE)
}
\arguments{
\item{h3_address}{Character; 15-character cell index generated by H3.}

\item{ring_size}{Character; number of steps away from the central cell.
Defaults to 1.}

\item{simple}{Logical; whether to return a vector of outputs or a data frame
containing both inputs and outputs.}
}
\value{
By default, a list of length(h3_address). Each list element contains
  a character vector of H3 cells belonging to that step away from the
  input address.
}
\description{
This function returns all the H3 cell indexes at the specified step from the
address supplied.
}
\note{
In total, the number of cells returned for each input index is
  `ring_size \* 6`.
}
\examples{
# What are the neighbours of this cell at step 2?
get_ring(h3_address = '86be8d12fffffff', ring_size = 2)
}
