% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain.R
\name{h2o.explain}
\alias{h2o.explain}
\title{Generate Model Explanations}
\usage{
h2o.explain(
  object,
  newdata,
  columns = NULL,
  top_n_features = 5,
  include_explanations = "ALL",
  exclude_explanations = NULL,
  plot_overrides = NULL
)
}
\arguments{
\item{object}{One of the following: an H2O model, a list of H2O models, an H2OAutoML object or 
an H2OAutoML Leaderboard slice.}

\item{newdata}{An H2OFrame.}

\item{columns}{A vector of column names or column indices to create plots with. If specified
parameter top_n_features will be ignored.}

\item{top_n_features}{An integer specifying the number of columns to use, ranked by variable importance
(where applicable).}

\item{include_explanations}{If specified, return only the specified model explanations.
(Mutually exclusive with exclude_explanations)}

\item{exclude_explanations}{Exclude specified model explanations.}

\item{plot_overrides}{Overrides for individual model explanations, e.g. 
\code{list(shap_summary_plot = list(columns = 50))}.}
}
\value{
List of outputs with class "H2OExplanation"
}
\description{
The H2O Explainability Interface is a convenient wrapper to a number of explainabilty 
methods and visualizations in H2O.  The function can be applied to a single model or group 
of models and returns a list of explanations, which are individual units of explanation 
such as a partial dependence plot or a variable importance plot.  Most of the explanations 
are visual (ggplot plots).  These plots can also be created by individual utility functions 
as well.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

# Import the wine dataset into H2O:
f <- "https://h2o-public-test-data.s3.amazonaws.com/smalldata/wine/winequality-redwhite-no-BOM.csv"
df <-  h2o.importFile(f)

# Set the response
response <- "quality"

# Split the dataset into a train and test set:
splits <- h2o.splitFrame(df, ratios = 0.8, seed = 1)
train <- splits[[1]]
test <- splits[[2]]

# Build and train the model:
aml <- h2o.automl(y = response,
                  training_frame = train,
                  max_models = 10,
                  seed = 1)

# Create the explanation for whole H2OAutoML object
exa <- h2o.explain(aml, test)
print(exa)

# Create the explanation for the leader model
exm <- h2o.explain(aml@leader, test)
print(exm)
}
}
