% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.insertMissingValues}
\alias{h2o.insertMissingValues}
\title{Insert Missing Values into an H2OFrame}
\usage{
h2o.insertMissingValues(data, fraction = 0.1, seed = -1)
}
\arguments{
\item{data}{An H2OFrame object representing the dataset.}

\item{fraction}{A number between 0 and 1 indicating the fraction of entries
to replace with missing.}

\item{seed}{A random number used to select which entries to replace with
missing values. Default of \code{seed = -1} will automatically
generate a seed in H2O.}
}
\value{
Returns an H2OFrame object.
}
\description{
Randomly replaces a user-specified fraction of entries in an H2O dataset with missing values.
}
\section{WARNING}{
 This will modify the original dataset. Unless this is intended,
this function should only be called on a subset of the original.
}

\examples{
\donttest{
library(h2o)
h2o.init()

iris_hf <- as.h2o(iris)
summary(iris_hf)

irismiss <- h2o.insertMissingValues(iris_hf, fraction = 0.25)
head(irismiss)
summary(irismiss)
}
}
