% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-studies.R
\name{studies_tbl}
\alias{studies_tbl}
\title{Creates a studies table.}
\usage{
studies_tbl(
  study_id = character(),
  reported_trait = character(),
  initial_sample_size = character(),
  replication_sample_size = character(),
  gxe = logical(),
  gxg = logical(),
  snp_count = integer(),
  qualifier = character(),
  imputed = logical(),
  pooled = logical(),
  study_design_comment = character(),
  full_pvalue_set = logical(),
  user_requested = logical()
)
}
\arguments{
\item{study_id}{GWAS Catalog study accession identifier.}

\item{reported_trait}{Phenotypic trait as reported by the authors of the
study.}

\item{initial_sample_size}{Free text description of the initial cohort sample
size.}

\item{replication_sample_size}{Free text description of the replication
cohort sample size.}

\item{gxe}{Whether the study investigates a gene-environment interaction.}

\item{gxg}{Whether the study investigates a gene-gene interaction.}

\item{snp_count}{Number of variants passing quality control.}

\item{qualifier}{Qualifier of number of variants passing quality control.}

\item{imputed}{Whether variants were imputed.}

\item{pooled}{Whether samples were pooled.}

\item{study_design_comment}{Any other relevant study design information.}

\item{full_pvalue_set}{Whether full summary statistics are available for this
study.}

\item{user_requested}{Whether the addition of this study to the GWAS Catalog
was requested by a user.}
}
\value{
A \code{\link[tibble]{tibble}} whose columns are the named arguments
  to the function.
}
\description{
Creates a studies table.
}
\keyword{internal}
