% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_associations.R
\name{get_associations}
\alias{get_associations}
\title{Get GWAS Catalog associations}
\usage{
get_associations(
  study_id = NULL,
  association_id = NULL,
  variant_id = NULL,
  efo_id = NULL,
  pubmed_id = NULL,
  efo_trait = NULL,
  set_operation = "union",
  interactive = TRUE,
  verbose = FALSE,
  warnings = TRUE
)
}
\arguments{
\item{study_id}{A \code{character} vector of GWAS Catalog study accession
identifiers.}

\item{association_id}{A \code{character} vector of GWAS Catalog association
identifiers.}

\item{variant_id}{A \code{character} vector of GWAS Catalog variant
identifiers.}

\item{efo_id}{A character vector of \href{https://www.ebi.ac.uk/efo/}{EFO}
identifiers.}

\item{pubmed_id}{An \code{integer} vector of
\href{https://en.wikipedia.org/wiki/PubMed}{PubMed} identifiers.}

\item{efo_trait}{A \code{character} vector of
\href{https://www.ebi.ac.uk/efo/}{EFO} trait descriptions, e.g.,
\code{'uric acid measurement'}.}

\item{set_operation}{Either \code{'union'} or \code{'intersection'}. This
tells how associations retrieved by different criteria  should be combined:
\code{'union'} binds together all results removing duplicates and
\code{'intersection'} only keeps same associations found with different
criteria.}

\item{interactive}{A logical. If all associations are requested, whether to ask
interactively if we really want to proceed.}

\item{verbose}{A \code{logical} indicating whether the function should be
verbose about the different queries or not.}

\item{warnings}{A \code{logical} indicating whether to print warnings, if any.}
}
\value{
An \linkS4class{associations} object.
}
\description{
Retrieves associations via the NHGRI-EBI GWAS Catalog REST API. The REST
API is queried multiple times with the criteria passed as arguments (see
below). By default all associations that match the criteria supplied in the
arguments are retrieved: this corresponds to the default option
\code{set_operation} set to \code{'union'}. If you rather have only the
associations that match simultaneously all criteria provided, then set
\code{set_operation} to \code{'intersection'}.
}
\details{
Please note that all search criteria are vectorised, thus allowing for batch
mode search, e.g., one can search by multiple variant identifiers at once by
passing a vector of identifiers to \code{variant_id}.
}
\examples{
# Get an association by study identifier
get_associations(study_id = 'GCST001085')

# Get an association by association identifier
get_associations(association_id = '25389945')

# Get associations by variant identifier
get_associations(variant_id = 'rs3798440')

# Get associations by EFO trait identifier
get_associations(efo_id = 'EFO_0005537')

}
