% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_hierarchical.R
\name{filter_hierarchical}
\alias{filter_hierarchical}
\alias{filter_hierarchical.tbl_hierarchical}
\alias{filter_hierarchical.tbl_hierarchical_count}
\title{Filter Hierarchical Tables}
\usage{
filter_hierarchical(x, ...)

\method{filter_hierarchical}{tbl_hierarchical}(x, filter, keep_empty = FALSE, ...)

\method{filter_hierarchical}{tbl_hierarchical_count}(x, filter, keep_empty = FALSE, ...)
}
\arguments{
\item{x}{(\code{tbl_hierarchical}, \code{tbl_hierarchical_count})\cr
A hierarchical gtsummary table of class \code{'tbl_hierarchical'} or \code{'tbl_hierarchical_count'}.}

\item{...}{These dots are for future extensions and must be empty.}

\item{filter}{(\code{expression})\cr
An expression that is used to filter rows of the table. See the Details section below.}

\item{keep_empty}{(scalar \code{logical})\cr
Logical argument indicating whether to retain summary rows corresponding to table hierarchy sections that have had
all rows filtered out. Default is \code{FALSE}.}
}
\value{
A \code{gtsummary} of the same class as \code{x}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}\cr

This function is used to filter hierarchical table rows. Filters are not applied to summary or overall rows.
}
\details{
The \code{filter} argument can be used to filter out rows of a table which do not meet the criteria provided as an
expression. Rows can be filtered on the values of any of the possible statistics (\code{n}, \code{p}, and \code{N}) provided they
are included at least once in the table, as well as the values of any \code{by} variables. Filtering is only applied to
rows that correspond to the innermost variable in the hierarchy - all outer variable (summary) rows are kept
regardless of whether they meet the filtering criteria themselves. In addition to filtering on individual statistic
values, filters can be applied across the row (i.e. across all \code{by} variable values) by using aggregate functions
such as \code{sum()} and \code{mean()}.

If an overall column was added to the table (via \verb{add_overall())}) this column will not be used in any filters (i.e.
\code{sum(n)} will not include the overall \code{n} in a given row). To filter on overall statistics use the \code{sum()} function
in your filter instead (i.e. \code{sum(n)} is equal to the overall column \code{n} across any \code{by} variables).

Some examples of possible filters:
\itemize{
\item \code{filter = n > 5}: keep rows where one of the treatment groups observed more than 5 AEs
\item \code{filter = n == 2 & p < 0.05}: keep rows where one of the treatment groups observed exactly 2 AEs and one of the
treatment groups observed a proportion less than 5\%.
\item \code{filter = sum(n) >= 4}: keep rows where there were 4 or more AEs observed across the row
\item \code{filter = mean(n) > 4 | n > 3}: keep rows where the mean number of AEs is 4 or more across the row or one of the
treatment groups observed more than 3 AEs
\item \code{filter = any(n > 2 & TRTA == "Xanomeline High Dose")}: keep rows where the \code{"Xanomeline High Dose"} treatment
group observed more than 2 AEs
}
}
\examples{
\dontshow{if ((identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ADAE_subset <- cards::ADAE |>
  dplyr::filter(AEBODSYS \%in\% c("SKIN AND SUBCUTANEOUS TISSUE DISORDERS",
                                "EAR AND LABYRINTH DISORDERS")) |>
  dplyr::filter(.by = AEBODSYS, dplyr::row_number() < 20)

tbl <-
  tbl_hierarchical(
    data = ADAE_subset,
    variables = c(AEBODSYS, AEDECOD),
    by = TRTA,
    denominator = cards::ADSL |> mutate(TRTA = ARM),
    id = USUBJID,
    overall_row = TRUE
  )

# Example 1 ----------------------------------
# Keep rows where less than 2 AEs are observed across the row
filter_hierarchical(tbl, sum(n) < 2)

# Example 2 ----------------------------------
# Keep rows where at least one treatment group in the row has at least 2 AEs observed
filter_hierarchical(tbl, n >= 2)

# Example 3 ----------------------------------
# Keep rows where AEs across the row have an overall prevalence of greater than 0.5\%
filter_hierarchical(tbl, sum(n) / sum(N) > 0.005)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=sort_hierarchical]{sort_hierarchical()}}
}
