% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_column_indent.R
\name{modify_column_indent}
\alias{modify_column_indent}
\title{Modify column indentation}
\usage{
modify_column_indent(x, columns, rows = NULL, indent = 4L, double_indent, undo)
}
\arguments{
\item{x}{(\code{gtsummary})\cr
gtsummary object}

\item{columns}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Selector of columns in \code{x$table_body}}

\item{rows}{(predicate \code{expression})\cr
Predicate expression to select rows in \code{x$table_body}.
Can be used to style footnote, formatting functions, missing symbols,
and text formatting. Default is \code{NULL}. See details below.}

\item{indent}{(\code{integer})\cr
An integer indicating how many space to indent text}

\item{double_indent, undo}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\value{
a gtsummary table
}
\description{
Add, increase, or reduce indentation for columns.
}
\examples{
# remove indentation from `tbl_summary()`
trial |>
  tbl_summary(include = grade) |>
  modify_column_indent(columns = label, indent = 0L)

# increase indentation in `tbl_summary`
trial |>
  tbl_summary(include = grade) |>
  modify_column_indent(columns = label, rows = !row_type \%in\% 'label', indent = 8L)
}
\seealso{
Other Advanced modifiers: 
\code{\link{modify_column_merge}()},
\code{\link{modify_table_styling}()}
}
\concept{Advanced modifiers}
