% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_global_p.R
\name{add_global_p.tbl_regression}
\alias{add_global_p.tbl_regression}
\title{Adds the global p-value for categorical variables}
\usage{
\method{add_global_p}{tbl_regression}(x, terms = NULL, keep = FALSE,
  ...)
}
\arguments{
\item{x}{Object with class \code{tbl_regression} from the
\link{tbl_regression} function}

\item{terms}{Character vector of terms for which to add global p-values.  Default
is \code{NULL} which will add global p-values for all categorical variables}

\item{keep}{Logical argument indicating whether to also retain the individual
p-values in the table output for each level of the categorical variable.
Default is \code{FALSE}}

\item{...}{Additional arguments to be passed to \link[car:Anova]{car::Anova}}
}
\value{
A \code{tbl_regression} object
}
\description{
This function uses \link[car:Anova]{car::Anova} with argument
\code{type = "III"} to calculate global p-values for categorical variables.
}
\section{Note}{

If a needed class of model is not supported by
\link[car:Anova]{car::Anova}, please create an
\href{https://github.com/ddsjoberg/gtsummary/issues}{issue} to request support.
}

\section{Example Output}{

\if{html}{\figure{tbl_lm_global_ex1.png}{options: width=50\%}}
}

\examples{
tbl_lm_global_ex1 <-
  lm(marker ~ age + grade, trial) \%>\%
  tbl_regression() \%>\%
  add_global_p()
}
\seealso{
Other tbl_regression tools: \code{\link{add_nevent.tbl_regression}},
  \code{\link{bold_italicize_labels_levels}},
  \code{\link{bold_p.tbl_regression}},
  \code{\link{bold_p.tbl_stack}},
  \code{\link{inline_text.tbl_regression}},
  \code{\link{modify_header}},
  \code{\link{sort_p.tbl_regression}},
  \code{\link{tbl_merge}}, \code{\link{tbl_regression}},
  \code{\link{tbl_stack}}
}
\author{
Daniel D. Sjoberg
}
\concept{tbl_regression tools}
