% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-summarize_categorical.R
\name{summarize_categorical}
\alias{summarize_categorical}
\title{Calculates and formats N's and percentages for categorical and dichotomous data}
\usage{
summarize_categorical(data, variable, by, var_label, stat_display,
  dichotomous_value, missing)
}
\arguments{
\item{data}{Data frame}

\item{variable}{Character variable name in \code{data} that will be tabulated}

\item{by}{Character variable name in \code{data} that Summary statistics for
\code{variable} are stratified}

\item{var_label}{String label}

\item{stat_display}{String that specifies the format of the displayed statistics.
The syntax follows \code{\link[glue]{glue}} inputs with n, N, and p as input options.}

\item{dichotomous_value}{If the output is dichotomous, then this is the value
of the variable that will be displayed.}

\item{missing}{whether to include \code{NA} values in the table. \code{missing} controls
if the table includes counts of \code{NA} values: the allowed values correspond to
never (\code{"no"}), only if the count is positive (\code{"ifany"}) and even for
zero counts (\code{"always"}). Default is \code{"ifany"}.}
}
\value{
formatted summary statistics in a tibble.
}
\description{
Calculates and formats N's and percentages for categorical and dichotomous data
}
\keyword{internal}
