% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_q.R
\name{add_q.fmt_uni_regression}
\alias{add_q.fmt_uni_regression}
\title{Add a column of q values to \code{fmt_uni_regression} object to account for
multiple comparisons}
\usage{
\method{add_q}{fmt_uni_regression}(x, method = "fdr", ...)
}
\arguments{
\item{x}{\code{table1} object}

\item{method}{character argument.  Methods from
\code{stats::}\code{\link[stats]{p.adjust}} are accepted.  Default is \code{method = fdr}.}

\item{...}{further arguments passed to or from other methods}
}
\description{
The adjustments to the p-values is performed with
\code{stats::}\code{\link[stats]{p.adjust}}.  The default method for correction
is false discovery rate (\code{"fdr"})
}
\examples{
lm(mpg ~ hp + am, mtcars) \%>\%
  fmt_regression() \%>\%
  bold_p()

trial \%>\%
  fmt_uni_regression(
    method = "lm",
    y = "age"
  ) \%>\%
  add_global() \%>\%
  add_q()
}
