% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_day_period.R
\name{filter_day_period}
\alias{filter_day_period}
\title{Filter GTFS data within a period of the day}
\usage{
filter_day_period(gtfs, period_start = "00:00:01", period_end = "23:59:59")
}
\arguments{
\item{gtfs}{A GTFS data.}

\item{period_start}{A string of type "hh:mm" indicating start of the period (defaults to "00:00:01")}

\item{period_end}{A string of type "hh:mm" indicating the end of the period (defaults to "23:59:59")}
}
\value{
A filtered GTFS data.
}
\description{
Updates a GTFS feed filtering only the routes, shapes, trips, stops,
 agencies and services that are active within a given period of the day.
}
\examples{
# read gtfs data
poa <- read_gtfs(system.file("extdata/poa.zip", package = "gtfs2gps"))

# filter gtfs data
poa_f <- filter_day_period(poa, period_start = "10:00", period_end = "10:20")
}
