% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_plt_dumbbell.R
\name{gt_plt_dumbbell}
\alias{gt_plt_dumbbell}
\title{Add a dumbbell plot in place of two columns}
\usage{
gt_plt_dumbbell(
  gt_object,
  col1 = NULL,
  col2 = NULL,
  label = NULL,
  palette = c("#378E38", "#A926B6", "#D3D3D3"),
  width = 70,
  text_args = list(accuracy = 1),
  text_size = 2.5
)
}
\arguments{
\item{gt_object}{an existing gt_tbl or pipeline}

\item{col1}{column 1, plot will replace this column}

\item{col2}{column 2, will be hidden}

\item{label}{an optional new label for the transformed column}

\item{palette}{must be 3 colors in order of col1, col2, bar color}

\item{width}{width in mm, defaults to 70}

\item{text_args}{A list of named arguments. Optional text arguments passed as a list to \code{scales::label_number}.}

\item{text_size}{A number indicating the size of the text indicators in the plot. Defaults to 1.5. Can also be set to \code{0} to "remove" the text itself.}
}
\value{
a gt_object table
}
\description{
Add a dumbbell plot in place of two columns
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{head(mtcars) \%>\%
  gt() \%>\%
  gt_plt_dumbbell(disp, mpg)
}\if{html}{\out{</div>}}
}

\section{Figures}{

\if{html}{\figure{gt_plt_dumbell.png}{options: width=70\%}}
}

