% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_img_circle.R
\name{gt_img_circle}
\alias{gt_img_circle}
\title{Create circular border around an image}
\usage{
gt_img_circle(
  gt_object,
  column,
  height = 25,
  border_color = "black",
  border_weight = 1.5
)
}
\arguments{
\item{gt_object}{An existing gt object}

\item{column}{The column to apply the transformation to}

\item{height}{A number indicating the height of the image in pixels.}

\item{border_color}{The color of the circular border, can either be a single value ie (\code{white} or \verb{#FF0000}) or a vector where the lenght of the vector is equal to the number of rows.}

\item{border_weight}{A number indicating the weight of the border in pixels.}
}
\value{
a gt object
}
\description{
Create circular border around an image
}
\section{Examples}{

library(gt)
gt_img_tab <- dplyr::tibble(
x = 1:4,
names = c("Rich Iannone",  "Katie Masiello", "Tom Mock","Hadley Wickham"),
img = c(
"https://pbs.twimg.com/profile_images/961326215792533504/Ih6EsvtF_400x400.jpg",
"https://pbs.twimg.com/profile_images/1471188460220260354/rHhoIXkZ_400x400.jpg",
"https://pbs.twimg.com/profile_images/1467219661121064965/Lfondr9M_400x400.jpg",
"https://pbs.twimg.com/profile_images/905186381995147264/7zKAG5sY_400x400.jpg"
)
) \%>\%
gt() \%>\%
gt_img_circle(img)
}

\section{Figures}{

\if{html}{\figure{gt_img_circle.png}{options: width=80\%}}
}

\section{Function ID}{

2-15
}

\seealso{
Other Utilities: 
\code{\link{add_text_img}()},
\code{\link{fa_icon_repeat}()},
\code{\link{fmt_pad_num}()},
\code{\link{fmt_pct_extra}()},
\code{\link{fmt_symbol_first}()},
\code{\link{generate_df}()},
\code{\link{gt_add_divider}()},
\code{\link{gt_badge}()},
\code{\link{gt_double_table}()},
\code{\link{gt_duplicate_column}()},
\code{\link{gt_fa_column}()},
\code{\link{gt_fa_rank_change}()},
\code{\link{gt_fa_rating}()},
\code{\link{gt_fa_repeats}()},
\code{\link{gt_highlight_cols}()},
\code{\link{gt_highlight_rows}()},
\code{\link{gt_img_rows}()},
\code{\link{gt_index}()},
\code{\link{gt_merge_stack}()},
\code{\link{gt_two_column_layout}()},
\code{\link{gtsave_extra}()},
\code{\link{img_header}()},
\code{\link{pad_fn}()},
\code{\link{tab_style_by_grp}()}
}
\concept{Utilities}
