% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/substitution.R
\name{sub_large_vals}
\alias{sub_large_vals}
\title{Substitute large values in the table body}
\usage{
sub_large_vals(
  data,
  columns = everything(),
  rows = everything(),
  threshold = 1e+12,
  large_pattern = ">={x}",
  sign = "+"
)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{columns}{The columns to format. Can either be a series of column names
provided in \code{\link[=c]{c()}}, a vector of column indices, or a helper function
focused on selections. The select helper functions are: \code{\link[=starts_with]{starts_with()}},
\code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=one_of]{one_of()}}, \code{\link[=num_range]{num_range()}}, and
\code{\link[=everything]{everything()}}.}

\item{rows}{Optional rows to format. Providing \code{\link[=everything]{everything()}} (the
default) results in all rows in \code{columns} being formatted. Alternatively,
we can supply a vector of row captions within \code{\link[=c]{c()}}, a vector of row
indices, or a helper function focused on selections. The select helper
functions are: \code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}},
\code{\link[=one_of]{one_of()}}, \code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}. We can also use expressions
to filter down to the rows we need (e.g.,
\verb{[colname_1] > 100 & [colname_2] < 50}).}

\item{threshold}{The threshold value with which values should be considered
large enough for replacement.}

\item{large_pattern}{The pattern text to be used in place of the suitably
large values in the rendered table.}

\item{sign}{The sign of the numbers to be considered in the replacement. By
default, we only consider positive values (\code{"+"}). The other option (\code{"-"})
can be used to consider only negative values.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Wherever there are numerical data that are very large in value, replacement
text may be better for explanatory purposes. The \code{sub_large_vals()} function
allows for this replacement through specification of a \code{threshold}, a
\code{large_pattern}, and the sign (positive or negative) of the values to be
considered.
}
\details{
Targeting of values is done through \code{columns} and additionally by \code{rows} (if
nothing is provided for \code{rows} then entire columns are selected). Conditional
formatting is possible by providing a conditional expression to the \code{rows}
argument. See the Arguments section for more information on this.
}
\section{Examples}{


Let's generate a simple, single-column tibble that contains an assortment of
values that could potentially undergo some substitution.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl <- dplyr::tibble(num = c(0, NA, 10^(8:14)))

tbl
#> # A tibble: 9 x 1
#>     num
#>   <dbl>
#> 1  0   
#> 2 NA   
#> 3  1e 8
#> 4  1e 9
#> 5  1e10
#> 6  1e11
#> 7  1e12
#> 8  1e13
#> 9  1e14
}\if{html}{\out{</div>}}

The \code{tbl} object contains a variety of larger numbers and some might be
larger enough to reformat with a threshold value. With \code{sub_large_vals()} we
can do just that:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl \%>\%
  gt() \%>\%
  fmt_number(columns = num) \%>\%
  sub_large_vals()
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_sub_large_vals_1.png" alt="This image of a table was generated from the first code example in the `sub_large_vals()` help file." style="width:100\%;">
}}

Large negative values can also be handled but they are handled specially
by the \code{sign} parameter. Setting that to \code{"-"} will format only the large
values that are negative. Notice that with the default \code{large_pattern}
value of \code{">={x}"} the \code{">="} is automatically changed to \code{"<="}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl \%>\%
  dplyr::mutate(num = -num) \%>\%
  gt() \%>\%
  fmt_number(columns = num) \%>\%
  sub_large_vals(sign = "-")
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_sub_large_vals_2.png" alt="This image of a table was generated from the second code example in the `sub_large_vals()` help file." style="width:100\%;">
}}

You don't have to settle with the default \code{threshold} value or the default
replacement pattern (in \code{large_pattern}). This can be changed and the
\code{"{x}"} in \code{large_pattern} (which uses the \code{threshold} value) can even be
omitted.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl \%>\%
  gt() \%>\%
  fmt_number(columns = num) \%>\%
  sub_large_vals(
    threshold = 5E10,
    large_pattern = "hugemongous"
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_sub_large_vals_3.png" alt="This image of a table was generated from the third code example in the `sub_large_vals()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

3-20
}

\seealso{
Other data formatting functions: 
\code{\link{data_color}()},
\code{\link{fmt_bytes}()},
\code{\link{fmt_currency}()},
\code{\link{fmt_datetime}()},
\code{\link{fmt_date}()},
\code{\link{fmt_duration}()},
\code{\link{fmt_engineering}()},
\code{\link{fmt_fraction}()},
\code{\link{fmt_integer}()},
\code{\link{fmt_markdown}()},
\code{\link{fmt_number}()},
\code{\link{fmt_partsper}()},
\code{\link{fmt_passthrough}()},
\code{\link{fmt_percent}()},
\code{\link{fmt_roman}()},
\code{\link{fmt_scientific}()},
\code{\link{fmt_time}()},
\code{\link{fmt}()},
\code{\link{sub_missing}()},
\code{\link{sub_small_vals}()},
\code{\link{sub_values}()},
\code{\link{sub_zero}()},
\code{\link{text_transform}()}
}
\concept{data formatting functions}
