% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_create_modify.R
\name{tab_source_note}
\alias{tab_source_note}
\title{Add a source note citation}
\usage{
tab_source_note(data, source_note)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{source_note}{Text to be used in the source note. We can optionally use
the \code{\link[=md]{md()}} and \code{\link[=html]{html()}} functions to style the text as Markdown or to
retain HTML elements in the text.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Add a source note to the footer part of the \strong{gt} table. A source note is
useful for citing the data included in the table. Several can be added to the
footer, simply use multiple calls of \code{tab_source_note()} and they will be
inserted in the order provided. We can use Markdown formatting for the note,
or, if the table is intended for HTML output, we can include HTML formatting.
}
\section{Examples}{


Use \code{\link{gtcars}} to create a \strong{gt} table. Use \code{tab_source_note()} to add a
source note to the table footer that cites the data source.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gtcars \%>\%
  dplyr::select(mfr, model, msrp) \%>\%
  dplyr::slice(1:5) \%>\%
  gt() \%>\%
  tab_source_note(source_note = "From edmunds.com")
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_tab_source_note_1.png" alt="This image of a table was generated from the first code example in the `tab_source_note()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

2-89
}

\seealso{
Other part creation/modification functions: 
\code{\link{tab_footnote}()},
\code{\link{tab_header}()},
\code{\link{tab_options}()},
\code{\link{tab_row_group}()},
\code{\link{tab_spanner_delim}()},
\code{\link{tab_spanner}()},
\code{\link{tab_stub_indent}()},
\code{\link{tab_stubhead}()},
\code{\link{tab_style}()}
}
\concept{part creation/modification functions}
