% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_group.R
\name{grp_clone}
\alias{grp_clone}
\title{Clone one or more \strong{gt} tables in a \code{gt_group} container object}
\usage{
grp_clone(data, which = NULL, before = NULL, after = NULL)
}
\arguments{
\item{data}{\emph{The gt table group object}

\verb{obj:<gt_group>} // \strong{required}

This is a \code{gt_group} container object. It is typically generated through
use of the \code{\link[=gt_group]{gt_group()}} function along with one or more \code{gt_tbl} objects,
or, made by splitting a \strong{gt} table with \code{\link[=gt_split]{gt_split()}}.}

\item{which}{\emph{The tables to clone}

\verb{vector<numeric|integer>} // \emph{default:} \code{NULL} (\code{optional})

A vector of index values denoting which \strong{gt} tables should be cloned
inside of the \code{gt_group} object.}

\item{before, after}{\emph{Table used as anchor}

\verb{scalar<numeric|integer>} // \emph{default:} \code{NULL} (\code{optional})

A single index for either \code{before} or \code{after}, specifies where the cloned
\code{gt_tbl} objects should be placed amongst the existing collection of \strong{gt}
tables. If nothing is provided for either argument, the incoming \code{gt_tbl}
objects will be appended.}
}
\value{
An object of class \code{gt_group}.
}
\description{
Should you have a \code{gt_group} object, created through use of the \code{\link[=gt_group]{gt_group()}}
function, you may in certain circumstances want to create replicas of
\code{gt_tbl} objects in that collection. This can be done with the \code{grp_clone()}
function and the placement of the cloned \strong{gt} tables can be controlled with
either the \code{before} or \code{after} arguments.
}
\section{Function ID}{

14-5
}

\section{Function Introduced}{

\code{v0.9.0} (Mar 31, 2023)
}

\seealso{
Other table group functions: 
\code{\link{grp_add}()},
\code{\link{grp_options}()},
\code{\link{grp_pull}()},
\code{\link{grp_replace}()},
\code{\link{grp_rm}()},
\code{\link{gt_group}()},
\code{\link{gt_split}()}
}
\concept{table group functions}
