% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{rename_samples}
\alias{rename_samples}
\alias{rename_samples.norm_data}
\alias{rename_samples.raw_data}
\title{Rename sample names}
\usage{
rename_samples(dat, ...)

\method{rename_samples}{raw_data}(dat, samples, suffix = NULL, ...)

\method{rename_samples}{norm_data}(dat, samples, ...)
}
\arguments{
\item{dat}{List object, containing at least two matrices "intensity" and "theta". Or matrix with raw data.}

\item{...}{Placeholder for generic function.}

\item{samples}{Matrix or data.frame with two columns: 1. (prefix of) colnames of dat and 2. meaningful sample name.}

\item{suffix}{Vector of two characters (e.g. c("Grn.idat", "Red.idat")) describing which suffix should be appended to the sample name.}
}
\value{
List with two matrices "intensity" (signal intensities) and "theta" (genotype value).
}
\description{
Rename sample names
}
\examples{
if(require(brassicaData)){
data(raw_napus, package = "brassicaData")
samples <- read_sample_sheets(files = list.files(system.file("extdata",
package = "brassicaData"), full.names = TRUE, pattern = "csv"))
raw_napus <- rename_samples(raw_napus, samples = samples[,2:1], suffix = c("_Grn", "_Red"))
}
}

