% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuez.R
\name{residuez}
\alias{residuez}
\title{Z-transform partial fraction expansion}
\usage{
residuez(b, a)
}
\arguments{
\item{b}{coefficients of numerator polynomial}

\item{a}{coefficients of denominator polynomial}
}
\value{
A list containing
\describe{
  \item{r}{vector of filter pole residues of the partial fraction}
  \item{p}{vector of partial fraction poles}
  \item{k}{vector containing FIR part, if any (empty if \code{length(b) <
  length(a)})}
}
}
\description{
Finds the residues, poles, and direct term of a Partial Fraction Expansion of
the ratio of two polynomials.
}
\details{
\code{residuez} converts a discrete time system, expressed as the ratio of
two polynomials, to partial fraction expansion, or residue, form.
}
\examples{
b0 <- 0.05634
b1 <- c(1,  1)
b2 <- c(1, -1.0166, 1)
a1 <- c(1, -0.683)
a2 <- c(1, -1.4461, 0.7957)
b <- b0 * conv(b1, b2)
a <- conv(a1, a2)
res <- residuez(b, a)

}
\seealso{
\code{\link{residue}}, \code{\link{residued}}
}
\author{
Julius O. Smith III, \email{jos@ccrma.stanford.edu}.\cr
 Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}
}
