% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dct.R
\name{dct}
\alias{dct}
\title{Discrete Cosine Transform}
\usage{
dct(x, n = NROW(x))
}
\arguments{
\item{x}{input data, specified as a numeric vector or matrix. In case of a
vector it represents a single signal; in case of a matrix each column is a
signal.}

\item{n}{transform length, specified as a positive integer scalar. Default:
\code{NROW(x)}.}
}
\value{
Discrete cosine transform, returned as a vector or matrix.
}
\description{
Compute the unitary discrete cosine transform of a signal.
}
\details{
The discrete cosine transform (DCT) is closely related to the discrete
Fourier transform. You can often reconstruct a sequence very accurately from
only a few DCT coefficients. This property is useful for applications
requiring data reduction.

The DCT has four standard variants. This function implements the DCT-II
according to the definition in [1], which is the most common variant, and
the original variant first proposed for image processing.
}
\note{
The transform is faster if \code{x} is real-valued and has even length.
}
\examples{
x <- matrix(seq_len(100) + 50 * cos(seq_len(100) * 2 * pi / 40))
X <- dct(x)

# Find which cosine coefficients are significant (approx.)
# zero the rest
nsig <- which(abs(X) < 1)
N <- length(X) - length(nsig) + 1
X[nsig] <- 0

# Reconstruct the signal and compare it to the original signal.
xx <- idct(X)
plot(x, type = "l")
lines(xx, col = "red")
legend("bottomright", legend = c("Original", paste("Reconstructed, N =", N)),
       lty = 1, col = 1:2)

}
\references{
[1] \url{https://en.wikipedia.org/wiki/Discrete_cosine_transform}
}
\seealso{
\code{\link{idct}}
}
\author{
Paul Kienzle, \email{pkienzle@users.sf.net}.\cr
 Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
