% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/besself.R
\name{besself}
\alias{besself}
\title{Bessel analog filter design}
\usage{
besself(n, w, type = c("low", "high", "stop", "pass"))
}
\arguments{
\item{n}{filter order.}

\item{w}{critical frequencies of the filter. \code{w} must be a scalar for
low-pass and high-pass filters, and \code{w} must be a two-element vector
c(low, high) specifying the lower and upper bands in radians/second.}

\item{type}{filter type, one of \code{"low"} (default), \code{"high"},
\code{"stop"}, or \code{"pass"}.}
}
\value{
List of class \code{'\link{Zpg}'} containing poles and gain of the
  filter.
}
\description{
Compute the transfer function coefficients of an analog Bessel filter.
}
\details{
Bessel filters are characterized by an almost constant group delay across the
entire passband, thus preserving the wave shape of filtered signals in the
passband.

Lowpass Bessel filters have a monotonically decreasing magnitude response, as
do lowpass Butterworth filters. Compared to the Butterworth, Chebyshev, and
elliptic filters, the Bessel filter has the slowest rolloff and requires the
highest order to meet an attenuation specification.
}
\note{
As the important characteristic of a Bessel filter is its
  maximally-flat group delay, and not the amplitude response, it is
  inappropriate to use the bilinear transform to convert the analog Bessel
  filter into a digital form (since this preserves the amplitude response but
  not the group delay) [1].
}
\examples{
w <- seq(0, 4, length.out = 128)

## 5th order Bessel low-pass analog filter
zp <- besself(5, 1.0)
freqs(zp, w)

## 5th order Bessel high-pass analog filter
zp <- besself(5, 1.0, 'high')
freqs(zp, w)

## 5th order Bessel band-pass analog filter
zp <- besself(5, c(1, 2), 'pass')
freqs(zp, w)

## 5th order Bessel band-stop analog filter
zp <- besself(5, c(1, 2), 'stop')
freqs(zp, w)

}
\references{
[1] \url{https://en.wikipedia.org/wiki/Bessel_filter}
}
\author{
Paul Kienzle, \email{pkienzle@users.sf.net},\cr
  Doug Stewart, \email{dastew@sympatico.ca},\cr
  Thomas Sailer, \email{t.sailer@alumni.ethz.ch}.\cr
  Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
