% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poly.R
\name{poly}
\alias{poly}
\title{Polynomial with specified roots}
\usage{
poly(x)
}
\arguments{
\item{x}{Real or complex vector, or square matrix.}
}
\value{
A vector of the coefficients of the polynomial in order from highest
  to lowest polynomial power.
}
\description{
Compute the coefficients of a polynomial when the roots are given, or the
characteristic polynomial of a matrix.
}
\details{
If a vector is passed as an argument, then \code{poly((x)} is a vector of the
coefficients of the polynomial whose roots are the elements of \code{x}.

If an \eqn{N x N} square matrix is given, \code{poly((x)}
is the row vector of the coefficients of \code{det (z * diag (N) - x)},
which is the characteristic polynomial of \code{x}.
}
\examples{
p <- poly(c(1, -1))
p <- poly(pracma::roots(1:3))
p <- poly(matrix(1:9, 3, 3))

}
\seealso{
\code{\link{roots}}
}
\author{
Kurt Hornik.\cr
 Conversion to R by Tom Short,\cr
  adapted by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}
}
