% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expected_event.R
\name{fastlag}
\alias{fastlag}
\title{Find the "previous" values in a vector}
\usage{
fastlag(x, first)
}
\arguments{
\item{x}{A vector (\code{length(x) > 0})}

\item{first}{A single value (\code{length(first) == 1})}
}
\value{
a vector that begins with \code{first} and is followed by \code{x}
with its final value removed
}
\description{
Fast replacement of \code{dplyr::lag} for the simple case of \code{n = 1L}
and always supplying a new value to insert at the beginning of the vector.
}
\details{
Important: this function is fast because it provides minimal safety checks.
It relies on the
\href{https://adv-r.hadley.nz/vectors-chap.html#testing-and-coercion}{coercion
rules} of \code{\link[base]{c}}. For best results, \code{x} and \code{first}
should be the same type of atomic vector, though it should be fine to mix
\code{numeric} and \code{integer} vectors as long as your own code also
doesn't rely on this distinction. It can also work on lists if needed.
}
\examples{
gsDesign2:::fastlag(1:5, first = 100) == c(100, 1:4)

}
\keyword{internal}
