% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsSurv.R
\name{eEvents}
\alias{eEvents}
\alias{print.eEvents}
\title{Expected number of events for a time-to-event study}
\usage{
eEvents(
  lambda = 1,
  eta = 0,
  gamma = 1,
  R = 1,
  S = NULL,
  T = 2,
  Tfinal = NULL,
  minfup = 0,
  digits = 4
)

\method{print}{eEvents}(x, digits = 4, ...)
}
\arguments{
\item{lambda}{scalar, vector or matrix of event hazard rates; rows represent
time periods while columns represent strata; a vector implies a single
stratum.}

\item{eta}{scalar, vector or matrix of dropout hazard rates; rows represent
time periods while columns represent strata; if entered as a scalar, rate is
constant across strata and time periods; if entered as a vector, rates are
constant across strata.}

\item{gamma}{a scalar, vector or matrix of rates of entry by time period
(rows) and strata (columns); if entered as a scalar, rate is constant
across strata and time periods; if entered as a vector, rates are constant
across strata.}

\item{R}{a scalar or vector of durations of time periods for recruitment
rates specified in rows of \code{gamma}. Length is the same as number of
rows in \code{gamma}. Note that the final enrollment period is extended as
long as needed.}

\item{S}{a scalar or vector of durations of piecewise constant event rates
specified in rows of \code{lambda}, \code{eta} and \code{etaE}; this is NULL
if there is a single event rate per stratum (exponential failure) or length
of the number of rows in \code{lambda} minus 1, otherwise.}

\item{T}{time of analysis; if \code{Tfinal=NULL}, this is also the study
duration.}

\item{Tfinal}{Study duration; if \code{NULL}, this will be replaced with
\code{T} on output.}

\item{minfup}{time from end of planned enrollment (\code{sum(R)} from output
value of \code{R}) until \code{Tfinal}.}

\item{digits}{which controls number of digits for printing.}

\item{x}{an object of class \code{eEvents} returned from \code{eEvents()}.}

\item{...}{Other arguments that may be passed to the generic print function.}
}
\value{
\code{eEvents()} and \code{print.eEvents()} return an object of
class \code{eEvents} which contains the following items: \item{lambda}{as
input; converted to a matrix on output.} \item{eta}{as input; converted to a
matrix on output.} \item{gamma}{as input.} \item{R}{as input.} \item{S}{as
input.} \item{T}{as input.} \item{Tfinal}{planned duration of study.}
\item{minfup}{as input.} \item{d}{expected number of events.}
\item{n}{expected sample size.} \item{digits}{as input.}
}
\description{
\code{eEvents()} is used to calculate the expected number of events for a
population with a time-to-event endpoint.  It is based on calculations
demonstrated in Lachin and Foulkes (1986) and is fundamental in computations
for the sample size method they propose. Piecewise exponential survival and
dropout rates are supported as well as piecewise uniform enrollment. A
stratified population is allowed. Output is the expected number of events
observed given a trial duration and the above rate parameters.

\code{eEvents()} produces an object of class \code{eEvents} with the number
of subjects and events for a set of pre-specified trial parameters, such as
accrual duration and follow-up period. The underlying power calculation is
based on Lachin and Foulkes (1986) method for proportional hazards assuming
a fixed underlying hazard ratio between 2 treatment groups. The method has
been extended here to enable designs to test non-inferiority. Piecewise
constant enrollment and failure rates are assumed and a stratified
population is allowed. See also \code{\link{nSurvival}} for other Lachin and
Foulkes (1986) methods assuming a constant hazard difference or exponential
enrollment rate.

\code{print.eEvents()} formats the output for an object of class
\code{eEvents} and returns the input value.
}
\examples{

# 3 enrollment periods, 3 piecewise exponential failure rates
str(eEvents(
  lambda = c(.05, .02, .01), eta = .01, gamma = c(5, 10, 20),
  R = c(2, 1, 2), S = c(1, 1), T = 20
))

# control group for example from Bernstein and Lagakos (1978)
lamC <- c(1, .8, .5)
n <- eEvents(
  lambda = matrix(c(lamC, lamC * 2 / 3), ncol = 6), eta = 0,
  gamma = matrix(.5, ncol = 6), R = 2, T = 4
)

}
\references{
Lachin JM and Foulkes MA (1986), Evaluation of Sample Size and
Power for Analyses of Survival with Allowance for Nonuniform Patient Entry,
Losses to Follow-Up, Noncompliance, and Stratification. \emph{Biometrics},
42, 507-519.

Bernstein D and Lagakos S (1978), Sample size and power determination for
stratified clinical trials. \emph{Journal of Statistical Computation and
Simulation}, 8:65-73.
}
\seealso{
\code{vignette("gsDesignPackageOverview")}, \link{plot.gsDesign},
\code{\link{gsDesign}}, \code{\link{gsHR}},
\code{\link{nSurvival}}
}
\author{
Keaven Anderson \email{keaven_anderson@merck.com}
}
\keyword{design}
