% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{coef.grpSLOPE}
\alias{coef.grpSLOPE}
\title{Extract model coefficients}
\usage{
\method{coef}{grpSLOPE}(object, scaled = TRUE, ...)
}
\arguments{
\item{object}{A \code{grpSLOPE} object}

\item{scaled}{Should the coefficients be returned for the normalized version of the design matrix?}

\item{...}{Potentially further arguments passed to and from methods}
}
\value{
A named vector of regression coefficients where the names signify the group that each entry belongs to
}
\description{
Extract the regression coefficients from a \code{grpSLOPE} object, either on the
scale of the normalized design matrix (i.e., columns centered and scaled to unit norm),
or on the original scale.
}
\details{
If \code{scaled} is set to \code{TRUE}, then the coefficients are returned for the 
normalized version of the design matrix, which is the scale on which they were computed. 
If \code{scaled} is set to \code{FALSE}, then the coefficients are transformed to
correspond to the original (unaltered) design matrix.
In case that \code{scaled = FALSE}, an estimate for the intercept term is returned with
the other coefficients. In case that \code{scaled = TRUE}, the estimate of the intercept 
is always equal to zero, and is not explicitly provided.
}
\examples{
set.seed(1)
A   <- matrix(rnorm(100^2), 100, 100)
grp <- rep(rep(letters[1:20]), each=5)
b   <- c(rep(1, 20), rep(0, 80))
y   <- A \%*\% b + rnorm(10) 
result <- grpSLOPE(X=A, y=y, group=grp, fdr=0.1)
head(coef(result), 8)
#       a_1       a_2       a_3       a_4       a_5       b_1       b_2       b_3 
#  7.942177  7.979269  8.667013  8.514861 10.026664  8.963364 10.037355 10.448692 
head(coef(result, scaled = FALSE), 8)
# (Intercept)         a_1         a_2         a_3         a_4         a_5         b_1         b_2 
#  -0.4418113   0.8886878   0.8372108   0.8422089   0.8629597   0.8615827   0.9323849   0.9333445 

}
