% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphing.R
\name{generate_report}
\alias{generate_report}
\title{Generate Automated Reports}
\usage{
generate_report(
  robj,
  data_report.reports_sel = c(1, 2, 3, 4),
  output_file = NULL,
  ...
)
}
\arguments{
\item{robj}{An R object containing analysis results from functions in this package.
The object's class determines which report template is used. Supported
classes depend on available templates in the package.}

\item{data_report.reports_sel}{Numeric vector.
Specifies which sections of the data report to include in the output:
1 = project level; 2 = species level; 3 = site level; 4 = radius level.
The default is `c(1, 2, 3, 4)`, which includes all sections.}

\item{output_file}{Character string. Optional path and filename for the output
HTML file. If NULL (default), the report is generated with an automatic
filename and opened in RStudio viewer.}

\item{...}{Additional parameters passed to the R Markdown template. Available
parameters vary by template type and are filtered to only include those
recognized by the selected template.}
}
\value{
Invisibly returns the file path of the generated report.
The function is primarily called for its side effect of generating the report file.
}
\description{
Creates HTML reports from various analysis objects using predefined
R Markdown templates. The function automatically selects the appropriate template
based on the input object's class and renders a comprehensive report with
visualizations and analysis results.
}
\examples{

# loading processed data
\donttest{
dt.samples_trt <- readRDS(system.file("extdata", "dt.samples_trt.rds", package = "growthTrendR"))
# genereate data summary report
outfile_data <- tempfile(fileext = ".html")
generate_report(robj = dt.samples_trt, output_file = outfile_data)
}
}
