% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_num.R
\name{aggregate_num}
\alias{aggregate_num}
\alias{aggregate_quantile}
\alias{aggregate_kerndens}
\title{Aggregate \link[base]{numeric} \link[spatstat.geom:hyperframe]{hypercolumns} and/or \link[spatstat.geom]{marks}, by Cluster}
\usage{
aggregate_num(
  X,
  by = stop("must specify `by`"),
  FUN,
  FUN.name = deparse1(substitute(FUN)),
  f_aggr_ = c("mean", "median", "max", "min"),
  mc.cores = switch(.Platform$OS.type, windows = 1L, detectCores()),
  ...
)

aggregate_quantile(X, ...)

aggregate_kerndens(X, ...)
}
\arguments{
\item{X}{a \link{groupedHyperframe},
containing either or all of
\itemize{
\item {one or more \link[base]{numeric}
\link[spatstat.geom:hyperframe]{hypercolumns}}
\item {one-and-only-one \link[spatstat.geom]{ppp}-\link[spatstat.geom:hyperframe]{hypercolumns}
with one or more \link[base]{numeric} \link[spatstat.geom]{marks}}
}}

\item{by}{one-sided \link[stats]{formula},
one-level hierarchy clustering, e.g., \code{~patient} or \code{~image}.
Do \strong{not} use multi-level hierarchy, e.g., \code{~patient/image}}

\item{FUN}{\link[base]{function} to extract information, currently supports
functions \link[stats]{quantile} and \link{kerndens}}

\item{FUN.name}{(optional) \link[base]{character} scalar,
user-friendly name of \code{FUN}}

\item{f_aggr_}{\link[base]{character} scalar, method to aggregate
within cluster, currently supports
\code{'mean'}, \code{'median'}, \code{'max'}, and \code{'min'}.}

\item{mc.cores}{\link[base]{integer} scalar, see function \link[parallel]{mclapply}.
Default is 1L on Windows, or \link[parallel]{detectCores} on Mac.
CRAN requires \code{mc.cores <= 2L} in examples.}

\item{...}{additional parameters of function \code{FUN}}
}
\value{
Function \code{\link[=aggregate_num]{aggregate_num()}} returns a \link[base]{data.frame}, with
aggregated information stored in \link[base]{matrix}-columns.
}
\description{
Aggregate \link[base]{numeric} \link[spatstat.geom:hyperframe]{hypercolumns}
and/or \link[spatstat.geom]{marks}
by sample clustering.
}
\details{
Function \code{\link[=aggregate_quantile]{aggregate_quantile()}} is a wrapper of
workhorse function \code{\link[=aggregate_num]{aggregate_num()}} with \code{FUN = quantile}.

Function \code{\link[=aggregate_kerndens]{aggregate_kerndens()}} is a wrapper of
workhorse function \code{\link[=aggregate_num]{aggregate_num()}} with \code{FUN = kerndens}.
}
