% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_loss.R
\name{estimate_loss}
\alias{estimate_loss}
\title{Estimate Loss}
\usage{
estimate_loss(
  posterior_samples,
  distribution,
  wrt_option = NULL,
  metric = c("absolute", "lift", "relative_risk")
)
}
\arguments{
\item{posterior_samples}{Tibble: returned from sample_from_posterior with 3 columns
`option_name`, `samples`, and `sample_id`.}

\item{distribution}{String: the name of the distribution}

\item{wrt_option}{String: the option loss is calculated with respect to (wrt). If NULL, the best option will be chosen.}

\item{metric}{String: the type of loss.
absolute will be the difference, on the outcome scale. 0 when best = wrt_option
lift will be the (best - wrt_option) / wrt_option, 0 when best = wrt_option
relative_risk will be the ratio best/wrt_option, 1 when best = wrt_option}
}
\value{
numeric, the loss distribution
}
\description{
Estimate Loss
}
\examples{
# Requires posterior_samples dataframe. See `sample_from_posterior()`
# for an example.

\dontrun{
estimate_loss(posterior_samples = posterior_samples, distribution = "conversion_rate")
}
}
