% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_scale.R
\name{star_scale}
\alias{star_scale}
\alias{star_angle}
\title{Compute regular star polygon scale or angles}
\usage{
star_scale(n_vertices, angle, external = FALSE)

star_angle(n_vertices, scale, external = FALSE)
}
\arguments{
\item{n_vertices}{Number of exterior vertices.}

\item{angle}{Angle in degrees.}

\item{external}{If \code{TRUE} angle should be considered an external angle.}

\item{scale}{Scale from 0 to 1.}
}
\value{
\code{star_scale()} returns a numeric value between 0 and 1 intended
for use as the \code{scale} argument in \code{\link[=grid.pattern_regular_polygon]{grid.pattern_regular_polygon()}}.
\code{star_angle()} returns a numeric value between 0 and 360 (degrees).
}
\description{
\code{star_scale()} computes star \code{scale} value given
an internal or external angle.  \code{star_angle()} computes
star angle (internal or external) given a \code{scale} value.
}
\details{
\code{\link[=grid.pattern_regular_polygon]{grid.pattern_regular_polygon()}} parameterizes regular star polygons
with the number of its external vertices and a \code{scale} that equals the
fraction of the radius of the circle that circumscribes the interior vertices
divided by the radius of the circle that circumscribes the exterior vertices.
These helper functions help convert between that parameterization
and either the internal or external angle of the regular star polygon.
}
\examples{
  # |8/3| star has internal angle 45 degrees and external angle 90 degrees
  scale <- star_scale(8, 45)
  scale2 <- star_scale(8, 90, external = TRUE)
  all.equal(scale, scale2)
  star_angle(8, scale)
  star_angle(8, scale, external = TRUE)

  if (require("grid")) {
    grid.pattern_regular_polygon(shape = "star8", scale = scale, angle = 0,
                                 spacing = 0.2, density = 0.8)
  }

}
