% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{coef.greybox}
\alias{coef.greybox}
\alias{coef.alm}
\alias{confint.alm}
\alias{vcov.alm}
\alias{summary.alm}
\title{Coefficients of the model and their statistics}
\usage{
\method{coef}{greybox}(object, bootstrap = FALSE, ...)

\method{confint}{alm}(object, parm, level = 0.95, bootstrap = FALSE, ...)

\method{vcov}{alm}(object, bootstrap = FALSE, ...)

\method{summary}{alm}(object, level = 0.95, bootstrap = FALSE, ...)
}
\arguments{
\item{object}{The model estimated using alm or other greybox function.}

\item{bootstrap}{The logical, which determines, whether to use bootstrap in the
process or not.}

\item{...}{Parameters passed to \link[greybox]{coefbootstrap} function.}

\item{parm}{The parameters that need to be extracted.}

\item{level}{The confidence level for the construction of the interval.}
}
\value{
Depending on the used method, different values are returned.
}
\description{
These are the basic methods for the alm and greybox models that extract coefficients,
their covariance matrix, confidence intervals or generating the summary of the model.
If the non-likelihood related loss was used in the process, then it is recommended to
use bootstrap (which is slow, but more reliable).
}
\details{
The \code{coef()} method returns the vector of parameters of the model. If
\code{bootstrap=TRUE}, then the coefficients are calculated as the mean values of the
bootstrapped ones.

The \code{vcov()} method returns the covariance matrix of parameters. If
\code{bootstrap=TRUE}, then the bootstrap is done using \link[greybox]{coefbootstrap}
function

The \code{confint()} constructs the confidence intervals for parameters. Once again,
this can be done using \code{bootstrap=TRUE}.

Finally, the \code{summary()} returns the table with parameters, their standard errors,
confidence intervals and general information about the model.
}
\examples{
# An example with ALM
ourModel <- alm(mpg~., mtcars, distribution="dlnorm")
coef(ourModel)
vcov(ourModel)
confint(ourModel)
summary(ourModel)

}
\seealso{
\code{\link[greybox]{alm}, \link[greybox]{coefbootstrap}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{ts}
